/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.util.Map;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.customfactory.CustomEjb3ConfigurationFactory;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.AuditEventListener;
import org.hibernate.event.PostInsertEventListener;

public class HibernateEjb3Database
extends HibernateDatabase {
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("hibernate:ejb3:");
    }

    @Override
    protected Configuration buildConfiguration(HibernateConnection connection) throws DatabaseException {
        Ejb3Configuration ejb3Configuration = this.isCustomFactoryClass(connection.getPath()) ? this.buildConfigurationFromFactory(connection) : this.buildConfigurationFromFile(connection);
        AnnotationConfiguration configuration = ejb3Configuration.getHibernateConfiguration();
        configuration.setProperty("hibernate.dialect", ejb3Configuration.getProperties().getProperty("hibernate.dialect"));
        String namingStrategy = ejb3Configuration.getProperties().getProperty("hibernate.ejb.naming_strategy");
        if (namingStrategy != null) {
            try {
                configuration.setNamingStrategy((NamingStrategy)Class.forName(namingStrategy).newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to instantiate naming strategy", e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Couldn't access naming strategy", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to find naming strategy", e);
            }
        }
        for (PostInsertEventListener postInsertEventListener : configuration.getEventListeners().getPostInsertEventListeners()) {
            if (!(postInsertEventListener instanceof AuditEventListener)) continue;
            AuditConfiguration.getFor((Configuration)configuration);
        }
        return configuration;
    }

    protected Ejb3Configuration buildConfigurationFromFactory(HibernateConnection connection) throws DatabaseException {
        try {
            return ((CustomEjb3ConfigurationFactory)Class.forName(connection.getPath()).newInstance()).getConfiguration(this, connection);
        }
        catch (InstantiationException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected Ejb3Configuration buildConfigurationFromFile(HibernateConnection connection) {
        Ejb3Configuration ejb3Configuration = new Ejb3Configuration();
        ejb3Configuration.configure(connection.getPath(), (Map)connection.getProperties());
        return ejb3Configuration;
    }

    protected boolean isCustomFactoryClass(String path) {
        if (path.contains("/")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(path);
            return CustomEjb3ConfigurationFactory.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getShortName() {
        return "hibernateEjb3";
    }

    protected String getDefaultDatabaseProductName() {
        return "Hibernate EJB3";
    }
}

