/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.statement.InsertManyStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="insertMany", description="Inserts multiple documents into a collection https://docs.mongodb.com/manual/reference/method/db.collection.insertMany/#db.collection.insertMany", priority=1, appliesTo={"collection"})
public class InsertManyChange
extends AbstractMongoChange {
    private String collectionName;
    private String documents;
    private String options;

    public String getConfirmationMessage() {
        return "Documents inserted into collection " + this.getCollectionName();
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new InsertManyStatement(this.collectionName, this.documents, this.options)};
    }

    public CheckSum generateCheckSum() {
        return super.generateCheckSum(this.collectionName, this.documents, this.options);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDocuments() {
        return this.documents;
    }

    public String getOptions() {
        return this.options;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setDocuments(String documents) {
        this.documents = documents;
    }

    public void setOptions(String options) {
        this.options = options;
    }
}

