/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import com.mongodb.client.model.Sorts;
import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlQueryForLongStatement;
import org.bson.Document;

public class GetMaxChangeSetSequenceStatement
extends AbstractCollectionStatement
implements NoSqlQueryForLongStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "maxSequence";

    public GetMaxChangeSetSequenceStatement(String collectionName) {
        super(collectionName);
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "();";
    }

    @Override
    public long queryForLong(MongoLiquibaseDatabase database) {
        Document max = (Document)database.getMongoDatabase().getCollection(this.getCollectionName()).find().sort(Sorts.descending((String[])new String[]{"orderExecuted"})).limit(1).first();
        return Optional.ofNullable(max).map(d -> (long)d.getInteger((Object)"orderExecuted")).orElse(0L);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetMaxChangeSetSequenceStatement)) {
            return false;
        }
        GetMaxChangeSetSequenceStatement other = (GetMaxChangeSetSequenceStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetMaxChangeSetSequenceStatement;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

