/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.snowflake.snapshot;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.snowflake.database.SnowflakeDatabase;
import liquibase.snapshot.jvm.SchemaSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.util.JdbcUtils;

public class SnowflakeSchemaSnapshotGenerator
extends SchemaSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        int priority = super.getPriority(objectType, database);
        if (database instanceof SnowflakeDatabase) {
            priority += 5;
        }
        return priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getDatabaseSchemaNames(Database database) throws SQLException, DatabaseException {
        ArrayList<String> returnList = new ArrayList<String>();
        try (ResultSet schemas = null;){
            schemas = ((JdbcConnection)database.getConnection()).getMetaData().getSchemas(database.getDefaultCatalogName(), database.getDefaultSchemaName());
            while (schemas.next()) {
                returnList.add(JdbcUtils.getValueForColumn((ResultSet)schemas, (String)"TABLE_SCHEM", (Database)database));
            }
        }
        return returnList.toArray(new String[returnList.size()]);
    }
}

