/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.Arrays;
import liquibase.command.AbstractCliWrapperCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;

public class RollbackOneUpdateCommandStep
extends AbstractCliWrapperCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneUpdate"};
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> DEPLOYMENT_ID_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_EXEC_LISTENER_CLASS_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_EXEC_LISTENER_PROPERTIES_FILE_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    protected String[] collectArguments(CommandScope commandScope) {
        return this.collectArguments(commandScope, Arrays.asList(FORCE_ARG.getName(), DEPLOYMENT_ID_ARG.getName()), null);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one update from the database"));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).required().description("The JDBC target database connection URL").build();
        DEFAULT_SCHEMA_NAME_ARG = commandBuilder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = commandBuilder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = commandBuilder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = commandBuilder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("The target database username").build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("The target database password").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        DEPLOYMENT_ID_ARG = commandBuilder.argument("deploymentId", String.class).description("The deployment ID of the update to rollback").build();
        CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().description("The root changelog").build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
        CHANGE_EXEC_LISTENER_CLASS_ARG = commandBuilder.argument("changeExecListenerClass", String.class).description("Fully-qualified class which specifies a ChangeExecListener").build();
        CHANGE_EXEC_LISTENER_PROPERTIES_FILE_ARG = commandBuilder.argument("changeExecListenerPropertiesFile", String.class).description("Path to a properties file for the ChangeExecListenerClass").build();
    }
}

