/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class Drop
implements Statement {
    private String type;
    private Table name;
    private List<String> parameters;
    private Map<String, List<String>> typeToParameters = new HashMap<String, List<String>>();
    private boolean ifExists = false;
    private boolean materialized = false;
    private boolean isUsingTemporary;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getName() {
        return this.name;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public void setName(Table table) {
        this.name = table;
    }

    public void setParameters(List<String> list) {
        this.parameters = list;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean bl2) {
        this.ifExists = bl2;
    }

    public boolean isUsingTemporary() {
        return this.isUsingTemporary;
    }

    public void setUsingTemporary(boolean bl2) {
        this.isUsingTemporary = bl2;
    }

    public Drop withUsingTemporary(boolean bl2) {
        this.setUsingTemporary(bl2);
        return this;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setMaterialized(boolean bl2) {
        this.materialized = bl2;
    }

    public Map<String, List<String>> getTypeToParameters() {
        return this.typeToParameters;
    }

    public void setTypeToParameters(Map<String, List<String>> map) {
        this.typeToParameters = map;
    }

    public String toString() {
        String string = "DROP " + (this.isUsingTemporary ? "TEMPORARY " : "") + (this.materialized ? "MATERIALIZED " : "") + this.type + " " + (this.ifExists ? "IF EXISTS " : "") + this.name.toString();
        if (this.type.equals("FUNCTION")) {
            string = string + Drop.formatFuncParams(this.getParamsByType("FUNCTION"));
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            string = string + " " + PlainSelect.getStringList(this.parameters, false, false);
        }
        return string;
    }

    public static String formatFuncParams(List<String> list) {
        if (list == null) {
            return "";
        }
        if (list.isEmpty()) {
            return "()";
        }
        return PlainSelect.getStringList(list, true, true);
    }

    public List<String> getParamsByType(String string) {
        return this.typeToParameters.get(string);
    }

    public Drop withIfExists(boolean bl2) {
        this.setIfExists(bl2);
        return this;
    }

    public Drop withMaterialized(boolean bl2) {
        this.setMaterialized(bl2);
        return this;
    }

    public Drop withType(String string) {
        this.setType(string);
        return this;
    }

    public Drop withName(Table table) {
        this.setName(table);
        return this;
    }

    public Drop withParameters(List<String> list) {
        this.setParameters(list);
        return this;
    }

    public Drop addParameters(String ... stringArray) {
        List list = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withParameters(list);
    }

    public Drop addParameters(Collection<String> collection) {
        List list = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withParameters(list);
    }
}

