/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public enum Constraint {
    NOT_NULL(object -> {
        if ((object = object.getColumns()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Column column = (Column)object.next();
                if (column.isNullable().booleanValue()) continue;
                hashSet.add(column.getName());
            }
            return hashSet;
        }
        return Collections.emptySet();
    }),
    UNIQUE(object -> {
        if ((object = object.getUniqueConstraints()) != null) {
            HashSet hashSet = new HashSet();
            object = object.iterator();
            while (object.hasNext()) {
                UniqueConstraint uniqueConstraint = (UniqueConstraint)object.next();
                hashSet.addAll(uniqueConstraint.getColumns().stream().map(Column::getName).collect(Collectors.toList()));
            }
            return hashSet;
        }
        return Collections.emptySet();
    }),
    PRIMARYKEY(table -> {
        if ((table = table.getPrimaryKey()) != null) {
            return table.getColumns().stream().map(Column::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }),
    FOREIGNKEY(object -> {
        if ((object = object.getOutgoingForeignKeys()) != null) {
            HashSet hashSet = new HashSet();
            object = object.iterator();
            while (object.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)object.next();
                hashSet.addAll(foreignKey.getForeignKeyColumns().stream().map(Column::getName).collect(Collectors.toSet()));
            }
            return hashSet;
        }
        return Collections.emptySet();
    }),
    DEFAULT(object -> {
        if ((object = object.getColumns()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Column column = (Column)object.next();
                if (column.getDefaultValue() == null) continue;
                hashSet.add(column.getName());
            }
            return hashSet;
        }
        return Collections.emptySet();
    });

    private final Function<Table, Set<String>> getColumnNamesCallback;

    private Constraint(Function<Table, Set<String>> function) {
        this.getColumnNamesCallback = function;
    }

    public final Set<String> getColumnNames(Table table) {
        return this.getColumnNamesCallback.apply(table);
    }
}

