/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.database.jvm;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.database.jvm.JdbcConnection;

public class ProJdbcConnection
extends JdbcConnection {
    private String username;
    private String password;
    public static final String MATCH_ORACLE_CREDS = "(?i)jdbc:oracle:thin:(.*?)([/])(.*?)((?=@)).*";

    public ProJdbcConnection() {
    }

    public ProJdbcConnection(Connection connection) {
        super(connection);
    }

    public int getPriority() {
        return 101;
    }

    public void open(String string, Driver object, Properties object2) {
        super.open(string, (Driver)object, (Properties)object2);
        object = ((Properties)object2).getProperty("password");
        if (object == null) {
            object = this.getPasswordFromUrl(string);
        }
        object2 = ((Properties)object2).getProperty("user");
        String[] stringArray = null;
        if (object2 == null || object == null) {
            stringArray = this.getOracleCredentialsFromUrl(string);
        }
        if (object2 == null) {
            object2 = stringArray[0];
        }
        if (object == null) {
            object = stringArray[1];
        }
        this.setPassword((String)object);
        this.setUsername((String)object2);
    }

    public String getConnectionUserName() {
        if (this.username == null) {
            return super.getConnectionUserName();
        }
        if (!this.username.contains("[") || !this.username.contains("]")) {
            return super.getConnectionUserName();
        }
        return this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPasswordFromUrl(String stringArray) {
        String string = null;
        if ((stringArray = stringArray.split("password=")).length > 1) {
            int n2 = stringArray[1].indexOf(38);
            string = stringArray[1].substring(0, n2 > 0 ? n2 : stringArray[1].length());
        }
        return string;
    }

    private String[] getOracleCredentialsFromUrl(String object) {
        String[] stringArray = new String[2];
        object = Pattern.compile(MATCH_ORACLE_CREDS).matcher((CharSequence)object);
        if (((Matcher)object).matches()) {
            stringArray[0] = ((Matcher)object).group(1);
            stringArray[1] = ((Matcher)object).group(3);
        }
        return stringArray;
    }
}

