/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.FlowShellCommandChange;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtil;
import liquibase.util.SystemUtil;

public class FlowShellCommandAction
extends Action {
    private String command;
    private String expandedCommand;
    private List<String> argsList;
    private FlowShellCommandChange commandChange;
    private String interpreter = SystemUtil.isWindows() ? "cmd" : "bash";
    private static final String COMMAND_KEY = "command";

    @Override
    public String getType() {
        return "shell";
    }

    public String toString() {
        return String.format("'%s' %s", this.getType(), this.command);
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(String string) {
        this.interpreter = string;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getExpandedCommand() {
        return this.expandedCommand;
    }

    public void setExpandedCommand(String string) {
        this.expandedCommand = string;
    }

    public List<String> getArgsList() {
        return this.argsList;
    }

    public void setArgsList(List<String> list) {
        this.argsList = list;
    }

    @Override
    public Action fromAction(Map<String, Object> stringArray, Map<String, Object> map) {
        FlowShellCommandAction flowShellCommandAction = new FlowShellCommandAction();
        if (StringUtil.isEmpty((String)(stringArray = (String)stringArray.get(COMMAND_KEY)))) {
            throw new IllegalArgumentException("Empty command found");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(COMMAND_KEY, stringArray);
        stringArray = FlowVariableExpander.expandVariables(hashMap, map);
        flowShellCommandAction.setExpandedCommand((String)stringArray.get(COMMAND_KEY));
        stringArray = FlowShellCommandAction.parseToArray((String)stringArray.get(COMMAND_KEY));
        if (!stringArray[0].equals(this.interpreter)) {
            FlowShellCommandAction flowShellCommandAction2 = flowShellCommandAction;
            flowShellCommandAction2.setCommand(flowShellCommandAction2.getExpandedCommand());
        } else {
            flowShellCommandAction.setCommand(this.interpreter);
        }
        if (stringArray.length > 1) {
            stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            flowShellCommandAction.setArgsList(Arrays.asList(stringArray));
        }
        flowShellCommandAction.commandChange = new FlowShellCommandChange();
        return flowShellCommandAction;
    }

    @Override
    public void validate(String string) {
    }

    @Override
    public void execute(CommandResultsBuilder commandResultsBuilder) {
        String[] stringArray = (String[])(commandResultsBuilder = commandResultsBuilder.getCommandScope()).getArgumentValue(FlowCommandStep.FLOW_SHELL_INTERPRETER);
        if (stringArray != null) {
            this.setInterpreter((String)stringArray);
        }
        Scope.getCurrentScope().getLog(FlowCommandStep.class).info("Using interpreter '" + this.interpreter + "'");
        boolean bl2 = (Boolean)commandResultsBuilder.getArgumentValue(FlowCommandStep.FLOW_SHELL_KEEP_TEMP_FILES);
        if (!this.command.equals(this.interpreter)) {
            Object object = this.createTempFile(bl2);
            stringArray = this.getExpandedCommand().split("\n");
            this.addCommandsToTempFile(stringArray, (Path)object);
            this.setArgsList(new ArrayList<String>());
            if (this.interpreter.equals("cmd")) {
                this.argsList.add("/c");
            } else {
                this.argsList.add("-c");
            }
            object = object.toFile().getAbsolutePath();
            if (SystemUtil.isWindows() && this.interpreter.equals("bash")) {
                object = ((String)object).replace("\\", "\\\\");
            }
            this.argsList.add((String)object);
        }
        FlowShellCommandAction flowShellCommandAction = this;
        flowShellCommandAction.setCommand(flowShellCommandAction.interpreter);
        this.commandChange.setExecutable(this.command);
        if (this.argsList != null) {
            this.argsList.forEach(arg_0 -> ((FlowShellCommandChange)this.commandChange).addArg(arg_0));
        }
        this.commandChange.createShellCommandArray();
        try {
            this.commandChange.executeShellCommand();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private Path createTempFile(boolean bl2) {
        Path path;
        try {
            Object object;
            if (SystemUtil.isWindows()) {
                if (this.interpreter.equals("bash")) {
                    object = Files.createTempFile("flow-", ".sh", new FileAttribute[0]).toFile();
                    if (!((File)object).setExecutable(true)) {
                        throw new UnexpectedLiquibaseException("Unable to set file '" + ((File)object).getAbsolutePath() + "' as executable");
                    }
                } else {
                    object = Files.createTempFile("flow-", ".bat", new FileAttribute[0]).toFile();
                }
            } else {
                object = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
                object = Files.createTempFile("flow-", ".sh", new FileAttribute[]{object}).toFile();
            }
            if (!bl2) {
                ((File)object).deleteOnExit();
            }
            path = ((File)object).toPath();
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
        return path;
    }

    private static String[] parseToArray(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return new String[0];
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        block4: while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if ("'".equals(stringArray)) {
                        bl2 = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(stringArray)) {
                        bl2 = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
            }
            if ("'".equals(stringArray)) {
                n2 = 1;
            } else if ("\"".equals(stringArray)) {
                n2 = 2;
            } else if (" ".equals(stringArray)) {
                if (bl2 || stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
            } else {
                stringBuilder.append((String)stringArray);
            }
            bl2 = false;
        }
        if (bl2 || stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n2 == 1 || n2 == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in ".concat(String.valueOf(string)));
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addCommandsToTempFile(String[] object, Path object2) {
        try {
            block12: {
                object2 = Files.newBufferedWriter((Path)object2, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    int n2 = ((Object)object).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = ((String)object[i2]).trim().replace("\r", "");
                        ((Writer)object2).write(string + "\n");
                    }
                    if (object2 == null) return;
                    if (throwable == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable4) {
                        if (object2 == null) throw throwable4;
                        if (throwable == null) {
                            ((BufferedWriter)object2).close();
                            throw throwable4;
                        }
                        try {
                            ((BufferedWriter)object2).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                try {
                    ((BufferedWriter)object2).close();
                    return;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return;
                }
            }
            ((BufferedWriter)object2).close();
            return;
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
    }
}

