/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.storedproc.StoredProcedureSnapshotGenerator;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;
import liquibase.util.StringUtil;

public class SnowflakeStoredProcedureSnapshotGenerator
extends StoredProcedureSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof SnowflakeDatabase) {
            int n2 = super.getPriority(clazz, database);
            if (n2 > 0) {
                return 50;
            }
            return n2;
        }
        return -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{StoredProcedureSnapshotGenerator.class};
    }

    public String parseArguments(String string) {
        return string.replaceAll("\\w+\\s", "");
    }

    public String getBody(StoredDatabaseLogic<?> object, String string, Database database) {
        object = " SELECT GET_DDL('procedure', '" + object.getName() + string + "')";
        return (String)((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForObject((SqlStatement)new RawSqlStatement(object), String.class);
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        Object object = this.getSnapshotObjectSql(storedDatabaseLogic, database);
        object = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawSqlStatement((String)object));
        object = this.castToListOfMaps(object);
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map)object.next();
            if (string == null) {
                string = (String)object2.get("OBJECT_NAME");
            }
            object2 = this.parseArguments((String)object2.get("OBJECT_ARG"));
            object2 = this.getBody(storedDatabaseLogic, (String)object2, database);
            stringBuilder.append(((String)object2).replaceFirst("\\r?\\n$", "")).append("\n");
        }
        stringBuilder = new StringBuilder(StringUtil.trimToEmpty((String)stringBuilder.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n")));
        return ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(storedDatabaseLogic.getSchema())).setName(string)).setBody(stringBuilder.toString());
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) {
        return "SELECT PROCEDURE_NAME AS OBJECT_NAME FROM INFORMATION_SCHEMA.PROCEDURES where PROCEDURE_SCHEMA='" + schema.getName() + "'";
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        return "SELECT PROCEDURE_SCHEMA AS OBJECT_SCHEMA, PROCEDURE_NAME AS OBJECT_NAME, ARGUMENT_SIGNATURE as OBJECT_ARG FROM INFORMATION_SCHEMA.PROCEDURES WHERE PROCEDURE_SCHEMA='" + storedDatabaseLogic.getSchema().getName() + "' AND PROCEDURE_NAME='" + storedDatabaseLogic.getName() + "'";
    }
}

