/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.storedlogic.AbstractUnexpectedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.DropTriggerChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;

public class UnexpectedTriggerChangeGenerator
extends AbstractUnexpectedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Trigger.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 101;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        object = new DropTriggerChange();
        if (diffOutputControl.getIncludeCatalog()) {
            if (((Trigger)databaseObject).getCatalog() == null) {
                ((DropTriggerChange)((Object)object)).setCatalogName(databaseObject.getSchema().getCatalogName());
            } else {
                ((DropTriggerChange)((Object)object)).setCatalogName(((Trigger)databaseObject).getCatalog().getName());
            }
        }
        if (((Trigger)databaseObject).getCatalog() != null) {
            ((DropTriggerChange)((Object)object)).setScope("CATALOG");
        }
        ((DropTriggerChange)((Object)object)).setTableName(((Trigger)databaseObject).getTableName());
        if (diffOutputControl.getIncludeSchema() && databaseObject.getSchema() != null) {
            ((DropTriggerChange)((Object)object)).setSchemaName(databaseObject.getSchema().getName());
        }
        ((DropTriggerChange)((Object)object)).setTriggerName(databaseObject.getName());
        return new Change[]{object};
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class, Function.class, StoredProcedure.class};
    }
}

