/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.ConfiguredValueModifier;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.ProvidedValue;
import liquibase.configuration.pro.UnlicensedVariableFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public abstract class ProConfiguredValueModifier<DataType>
implements ConfiguredValueModifier<DataType> {
    public final void override(ConfiguredValue<DataType> configuredValue) {
        ProvidedValue providedValue = configuredValue.getProvidedValue();
        String string = null;
        if (providedValue != null && providedValue.getValue() != null) {
            string = providedValue.getValue().toString().toLowerCase();
        }
        if (StringUtil.isEmpty(string) || !string.startsWith(this.getProviderPrefix() + ",")) {
            if (StringUtil.isNotEmpty(string) && string.contains(this.getProviderPrefix())) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("The property " + configuredValue.getProvidedValue().getRequestedKey() + " contains the keyword " + this.getProviderPrefix() + " but the plugin is not being used to decrypt this value.");
            }
            return;
        }
        providedValue = ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getRegisteredDefinition(configuredValue.getProvidedValue().getRequestedKey());
        if (CollectionUtil.createIfNull(this.getIllegalLookupConfigs()).contains(providedValue)) {
            throw new IllegalArgumentException("It is not possible to lookup the value for " + configuredValue.getProvidedValue().getActualKey() + " using the " + this.getName() + " plugin. Try setting the value for this configuration value using another mechanism, like environment variables.");
        }
        if (!((UnlicensedVariableFactory)Scope.getCurrentScope().getSingleton(UnlicensedVariableFactory.class)).isUnlicensed((ConfigurationDefinition<?>)providedValue) && !LicenseServiceUtils.isProLicenseValid()) {
            throw new IllegalArgumentException("Pro License Key required for " + this.getName() + " extension");
        }
        this.internalOverride(configuredValue);
    }

    public abstract void internalOverride(ConfiguredValue<DataType> var1);

    public abstract String getName();

    public abstract String getProviderPrefix();

    public List<ConfigurationDefinition<?>> getIllegalLookupConfigs() {
        return Collections.emptyList();
    }

    public int getOrder() {
        return 100;
    }
}

