/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.OutputClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertConflictAction;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertConflictTarget;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.InsertModifierPriority;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.values.ValuesStatement;

public class Insert
implements Statement {
    private Table table;
    private OracleHint oracleHint = null;
    private List<Column> columns;
    private Select select;
    private boolean useDuplicate = false;
    private List<Column> duplicateUpdateColumns;
    private List<Expression> duplicateUpdateExpressionList;
    private InsertModifierPriority modifierPriority = null;
    private boolean modifierIgnore = false;
    private List<SelectItem> returningExpressionList = null;
    private boolean useSet = false;
    private List<Column> setColumns;
    private List<Expression> setExpressionList;
    private List<WithItem> withItemsList;
    private OutputClause outputClause;
    private InsertConflictTarget conflictTarget;
    private InsertConflictAction conflictAction;

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    @Deprecated
    public ItemsList getItemsList() {
        Object object;
        if (this.select != null && (object = this.select.getSelectBody()) instanceof SetOperationList && (object = ((SetOperationList)object).getSelects()).size() == 1 && (object = (SelectBody)object.get(0)) instanceof ValuesStatement) {
            if (((ValuesStatement)(object = (ValuesStatement)object)).getExpressions() instanceof ExpressionList) {
                if (((ExpressionList)(object = (ExpressionList)((ValuesStatement)object).getExpressions())).getExpressions().size() == 1 && ((ExpressionList)object).getExpressions().get(0) instanceof RowConstructor) {
                    return ((RowConstructor)((ExpressionList)object).getExpressions().get(0)).getExprList();
                }
                return object;
            }
            return ((ValuesStatement)object).getExpressions();
        }
        return null;
    }

    @Deprecated
    public boolean isUseValues() {
        return this.select != null && this.select.getSelectBody() instanceof ValuesStatement;
    }

    public List<SelectItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectItem> list) {
        this.returningExpressionList = list;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    @Deprecated
    public boolean isUseSelectBrackets() {
        return false;
    }

    public boolean isUseDuplicate() {
        return this.useDuplicate;
    }

    public void setUseDuplicate(boolean bl2) {
        this.useDuplicate = bl2;
    }

    public List<Column> getDuplicateUpdateColumns() {
        return this.duplicateUpdateColumns;
    }

    public void setDuplicateUpdateColumns(List<Column> list) {
        this.duplicateUpdateColumns = list;
    }

    public List<Expression> getDuplicateUpdateExpressionList() {
        return this.duplicateUpdateExpressionList;
    }

    public void setDuplicateUpdateExpressionList(List<Expression> list) {
        this.duplicateUpdateExpressionList = list;
    }

    public InsertModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(InsertModifierPriority insertModifierPriority) {
        this.modifierPriority = insertModifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean bl2) {
        this.modifierIgnore = bl2;
    }

    public void setUseSet(boolean bl2) {
        this.useSet = bl2;
    }

    public boolean isUseSet() {
        return this.useSet;
    }

    public void setSetColumns(List<Column> list) {
        this.setColumns = list;
    }

    public List<Column> getSetColumns() {
        return this.setColumns;
    }

    public void setSetExpressionList(List<Expression> list) {
        this.setExpressionList = list;
    }

    public List<Expression> getSetExpressionList() {
        return this.setExpressionList;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public InsertConflictTarget getConflictTarget() {
        return this.conflictTarget;
    }

    public void setConflictTarget(InsertConflictTarget insertConflictTarget) {
        this.conflictTarget = insertConflictTarget;
    }

    public Insert withConflictTarget(InsertConflictTarget insertConflictTarget) {
        this.setConflictTarget(insertConflictTarget);
        return this;
    }

    public InsertConflictAction getConflictAction() {
        return this.conflictAction;
    }

    public void setConflictAction(InsertConflictAction insertConflictAction) {
        this.conflictAction = insertConflictAction;
    }

    public Insert withConflictAction(InsertConflictAction insertConflictAction) {
        this.setConflictAction(insertConflictAction);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<WithItem> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem withItem = iterator.next();
                stringBuilder.append(withItem);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("INSERT ");
        if (this.modifierPriority != null) {
            stringBuilder.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            stringBuilder.append("IGNORE ");
        }
        stringBuilder.append("INTO ");
        stringBuilder.append(this.table).append(" ");
        if (this.columns != null) {
            stringBuilder.append(PlainSelect.getStringList(this.columns, true, true)).append(" ");
        }
        if (this.outputClause != null) {
            stringBuilder.append(this.outputClause.toString());
        }
        if (this.select != null) {
            stringBuilder.append(this.select);
        }
        if (this.useSet) {
            stringBuilder.append("SET ");
            for (int i2 = 0; i2 < this.getSetColumns().size(); ++i2) {
                if (i2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.setColumns.get(i2)).append(" = ");
                stringBuilder.append(this.setExpressionList.get(i2));
            }
        }
        if (this.useDuplicate) {
            stringBuilder.append(" ON DUPLICATE KEY UPDATE ");
            for (int i3 = 0; i3 < this.getDuplicateUpdateColumns().size(); ++i3) {
                if (i3 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.duplicateUpdateColumns.get(i3)).append(" = ");
                stringBuilder.append(this.duplicateUpdateExpressionList.get(i3));
            }
        }
        if (this.conflictAction != null) {
            stringBuilder.append(" ON CONFLICT");
            if (this.conflictTarget != null) {
                this.conflictTarget.appendTo(stringBuilder);
            }
            this.conflictAction.appendTo(stringBuilder);
        }
        if (this.getReturningExpressionList() != null) {
            stringBuilder.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return stringBuilder.toString();
    }

    public Insert withWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
        return this;
    }

    public Insert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Insert withUseDuplicate(boolean bl2) {
        this.setUseDuplicate(bl2);
        return this;
    }

    public Insert withDuplicateUpdateColumns(List<Column> list) {
        this.setDuplicateUpdateColumns(list);
        return this;
    }

    public Insert withDuplicateUpdateExpressionList(List<Expression> list) {
        this.setDuplicateUpdateExpressionList(list);
        return this;
    }

    public Insert withModifierPriority(InsertModifierPriority insertModifierPriority) {
        this.setModifierPriority(insertModifierPriority);
        return this;
    }

    public Insert withModifierIgnore(boolean bl2) {
        this.setModifierIgnore(bl2);
        return this;
    }

    public Insert withReturningExpressionList(List<SelectItem> list) {
        this.setReturningExpressionList(list);
        return this;
    }

    public Insert withUseSet(boolean bl2) {
        this.setUseSet(bl2);
        return this;
    }

    public Insert withUseSetColumns(List<Column> list) {
        this.setSetColumns(list);
        return this;
    }

    public Insert withSetExpressionList(List<Expression> list) {
        this.setSetExpressionList(list);
        return this;
    }

    public Insert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Insert withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public Insert withSetColumns(List<Column> list) {
        this.setSetColumns(list);
        return this;
    }

    public Insert addColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withColumns(list);
    }

    public Insert addColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withColumns(list);
    }

    public Insert addDuplicateUpdateColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withDuplicateUpdateColumns(list);
    }

    public Insert addDuplicateUpdateColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getDuplicateUpdateColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withDuplicateUpdateColumns(list);
    }

    public Insert addDuplicateUpdateExpressionList(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withDuplicateUpdateExpressionList(list);
    }

    public Insert addDuplicateUpdateExpressionList(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getDuplicateUpdateExpressionList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withDuplicateUpdateExpressionList(list);
    }

    public Insert addReturningExpressionList(SelectItem ... selectItemArray) {
        List list = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withReturningExpressionList(list);
    }

    public Insert addReturningExpressionList(Collection<? extends SelectItem> collection) {
        List list = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withReturningExpressionList(list);
    }

    public Insert addSetColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getSetColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withSetColumns(list);
    }

    public Insert addSetColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getSetColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSetColumns(list);
    }

    public Insert addSetExpressionList(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getSetExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withSetExpressionList(list);
    }

    public Insert addSetExpressionList(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getSetExpressionList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSetExpressionList(list);
    }

    public <E extends ItemsList> E getItemsList(Class<E> clazz) {
        return (E)((ItemsList)clazz.cast(this.getItemsList()));
    }
}

