/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.GroupByVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class GroupByElement
implements Serializable {
    private ExpressionList groupByExpressions = new ExpressionList().withUsingBrackets(false);
    private List groupingSets = new ArrayList();

    public boolean isUsingBrackets() {
        return this.groupByExpressions.isUsingBrackets();
    }

    public void setUsingBrackets(boolean bl2) {
        this.groupByExpressions.setUsingBrackets(bl2);
    }

    public GroupByElement withUsingBrackets(boolean bl2) {
        this.groupByExpressions.setUsingBrackets(bl2);
        return this;
    }

    public void accept(GroupByVisitor groupByVisitor) {
        groupByVisitor.visit(this);
    }

    public ExpressionList getGroupByExpressionList() {
        return this.groupByExpressions;
    }

    public void setGroupByExpressionList(ExpressionList expressionList) {
        this.groupByExpressions = expressionList;
    }

    @Deprecated
    public List<Expression> getGroupByExpressions() {
        return this.groupByExpressions.getExpressions();
    }

    @Deprecated
    public void setGroupByExpressions(List<Expression> list) {
        this.groupByExpressions.setExpressions(list);
    }

    @Deprecated
    public void addGroupByExpression(Expression expression) {
        if (this.groupByExpressions.getExpressions() == null) {
            this.groupByExpressions.setExpressions(new ArrayList<Expression>());
        }
        this.groupByExpressions.getExpressions().add(expression);
    }

    public List getGroupingSets() {
        return this.groupingSets;
    }

    public void setGroupingSets(List list) {
        this.groupingSets = list;
    }

    public void addGroupingSet(Expression expression) {
        this.groupingSets.add(expression);
    }

    public void addGroupingSet(ExpressionList expressionList) {
        this.groupingSets.add(expressionList);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GROUP BY ");
        if (this.groupByExpressions.getExpressions() != null && this.groupByExpressions.getExpressions().size() > 0) {
            if (this.groupByExpressions.isUsingBrackets()) {
                stringBuilder.append("( ");
            }
            stringBuilder.append(PlainSelect.getStringList(this.groupByExpressions.getExpressions()));
            if (this.groupByExpressions.isUsingBrackets()) {
                stringBuilder.append(" )");
            }
        } else if (this.groupByExpressions.isUsingBrackets()) {
            stringBuilder.append("()");
        }
        if (this.groupingSets.size() > 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2.charAt(stringBuilder2.length() - 1) != ' ') {
                stringBuilder.append(' ');
            }
            stringBuilder.append("GROUPING SETS (");
            boolean bl2 = true;
            for (Object object : this.groupingSets) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                if (object instanceof Expression) {
                    stringBuilder.append(object.toString());
                    continue;
                }
                if (!(object instanceof ExpressionList)) continue;
                stringBuilder.append(((ExpressionList)(object = (ExpressionList)object)).getExpressions() == null ? "()" : ((ExpressionList)object).toString());
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public GroupByElement withGroupByExpressions(List<Expression> list) {
        this.setGroupByExpressions(list);
        return this;
    }

    public GroupByElement withGroupingSets(List list) {
        this.setGroupingSets(list);
        return this;
    }

    public GroupByElement addGroupByExpressions(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getGroupByExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withGroupByExpressions(list);
    }

    public GroupByElement addGroupByExpressions(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getGroupByExpressions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withGroupByExpressions(list);
    }

    public GroupByElement addGroupingSets(Object ... objectArray) {
        List list = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        Collections.addAll(list, objectArray);
        return this.withGroupingSets(list);
    }

    public GroupByElement addGroupingSets(Collection<? extends Object> collection) {
        List list = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withGroupingSets(list);
    }
}

