/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.Collection;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.database.DatabaseList;
import liquibase.util.StringUtil;

public class ProDbmsChangeSetFilter
extends DbmsChangeSetFilter {
    private String dbms;

    public ProDbmsChangeSetFilter(String string) {
        super(null);
        this.dbms = string;
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        if (this.dbms == null) {
            return new ChangeSetFilterResult(true, "No database specified, cannot evaluate dbms attribute", ((Object)((Object)this)).getClass(), this.getMdcName(), this.getDisplayName());
        }
        String string = changeSet.getDbmsSet() == null || changeSet.getDbmsSet().isEmpty() ? "all databases" : "'" + StringUtil.join((Collection)changeSet.getDbmsSet(), (String)", ") + "'";
        if (DatabaseList.definitionMatches((Collection)changeSet.getDbmsSet(), (String)this.dbms, (boolean)true)) {
            return new ChangeSetFilterResult(true, "Database '" + this.dbms + "' matches " + string, ((Object)((Object)this)).getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, "Database '" + this.dbms + "' does not match " + string, ((Object)((Object)this)).getClass(), this.getMdcName(), this.getDisplayName());
    }
}

