/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.resource.Resource;
import liquibase.util.StringUtil;

@Deprecated
public class FileEncoder {
    public static final String QUALITY_CHECKS_PREFIX = "Quality Checks Version:";
    private static final String LINE_SEPARATOR = "\n";
    @Deprecated
    private static final String SEPARATOR = "-----------------------------------------------------------------------------------------------";

    public static String generateFileHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        DynamicRuleParameterEnum[] object = DynamicRuleParameterEnum.values();
        Arrays.sort(object, Comparator.comparing(Enum::toString));
        for (DynamicRuleParameterEnum dynamicRuleParameterEnum : object) {
            stringBuilder.append("##    ");
            stringBuilder.append(dynamicRuleParameterEnum.toString());
            stringBuilder.append(": <");
            if (StringUtil.isEmpty((String)dynamicRuleParameterEnum.options)) {
                stringBuilder.append(dynamicRuleParameterEnum.interactiveCommandLineValueGetter.describe());
            } else {
                stringBuilder.append(dynamicRuleParameterEnum.options);
            }
            stringBuilder.append(">");
            stringBuilder.append(LINE_SEPARATOR);
        }
        String string = "## Quality Checks Settings File\n########## IMPORTANT: NEVER EDIT THIS KEY\n## id: 'some-l0ng-uni4ue-id3nt1fier-c0d3'\n\n########## ALWAYS EDITABLE KEY VALUES and PARAMETERS\n##  severity: <can be set to " + StringUtil.join((Collection)Arrays.stream(SeverityEnum.values()).map(SeverityEnum::getExitValue).sorted().collect(Collectors.toList()), (String)", ", Object::toString) + ">\n##  enabled: <can be \"true\" or \"false\">\n\n########## EDITABLE PARAMETERS\n##  Standard value options:" + LINE_SEPARATOR + stringBuilder;
        return string + LINE_SEPARATOR;
    }

    public static FileAccessorDTO decode(String string, Resource resource) {
        String string2;
        FileAccessorDTO fileAccessorDTO = new FileAccessorDTO();
        fileAccessorDTO.setOriginalContents(string);
        if (!FileEncoder.isVersioned(string)) {
            Scope.getCurrentScope().getLog(FileEncoder.class).info("The contents of this settings file are not versioned");
        } else {
            fileAccessorDTO.versioned = true;
        }
        try {
            string2 = new String(Base64.getDecoder().decode(FileEncoder.stripHeaderFromString(string)));
            fileAccessorDTO.encoded = true;
        }
        catch (Exception exception) {
            string2 = FileEncoder.stripHeaderFromString(string);
            fileAccessorDTO.encoded = false;
        }
        fileAccessorDTO.contents = string2;
        fileAccessorDTO.resource = resource;
        return fileAccessorDTO;
    }

    private static String stripHeaderFromString(String string) {
        int n2 = string.indexOf(SEPARATOR);
        if (n2 == -1) {
            return string;
        }
        if ((string = string.substring(n2 + 95)).startsWith(LINE_SEPARATOR)) {
            return string.replaceFirst(LINE_SEPARATOR, "");
        }
        if (string.startsWith("\r\n")) {
            return string.replaceFirst("\r\n", "");
        }
        return string;
    }

    private static boolean isVersioned(String string) {
        return string.contains(QUALITY_CHECKS_PREFIX);
    }
}

