/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.ProTagCommandStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.RollbackCommandStep;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.CommandValidationException;
import liquibase.license.LicenseServiceUtils;

@CommandOverride(override=RollbackCommandStep.class)
public class ProRollbackCommandStep
extends RollbackCommandStep {
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        super.run(commandResultsBuilder);
        try {
            LicenseServiceUtils.checkProLicenseAndThrowException((String[])RollbackCommandStep.COMMAND_NAME);
        }
        catch (CommandValidationException commandValidationException) {
            return;
        }
        commandResultsBuilder = commandResultsBuilder.getCommandScope();
        String string = (String)commandResultsBuilder.getArgumentValue(TAG_ARG);
        this.removeTagOrphans((CommandScope)commandResultsBuilder, string);
    }

    private void removeTagOrphans(CommandScope commandScope, String string) {
        commandScope = (Database)commandScope.getDependency(Database.class);
        Iterator iterator = new ArrayList(commandScope.getRanChangeSetList());
        Collections.reverse(iterator);
        boolean bl2 = false;
        ArrayList<RanChangeSet> arrayList = new ArrayList<RanChangeSet>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            RanChangeSet ranChangeSet = (RanChangeSet)iterator.next();
            if (!ranChangeSet.getId().startsWith("liquibasetagcommand")) continue;
            arrayList.add(ranChangeSet);
            if (!ranChangeSet.getTag().equals(string)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            for (RanChangeSet ranChangeSet : arrayList) {
                string = new ChangeSet(ranChangeSet.getId(), "liquibasetagcommand", false, false, "liquibasetagcommand", null, null, "jdbc", null, true, ObjectQuotingStrategy.LEGACY, null);
                commandScope.removeRanStatus((ChangeSet)string);
                Scope.getCurrentScope().getLog(ProTagCommandStep.class).info("Removed changelog entry for tag " + ranChangeSet.getTag());
            }
        }
    }

    public int getOrder(CommandDefinition commandDefinition) {
        int n2 = super.getOrder(commandDefinition);
        if (n2 < 0 && !commandDefinition.getName()[0].equals(RollbackCommandStep.COMMAND_NAME[0])) {
            return n2;
        }
        return 1100;
    }
}

