/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.AbstractRollbackOneCommand;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommandStep$1;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommandStep$ListenerStatus;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;

public class RollbackOneUpdateCommandStep
extends AbstractRollbackOneCommand {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneUpdate"};
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final CommandArgumentDefinition<String> DEPLOYMENT_ID_ARG;
    public static CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<Boolean> SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one update from the database"));
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class);
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Object object = commandResultsBuilder.getCommandScope();
        Object object2 = (Boolean)object.getArgumentValue(FORCE_ARG);
        Object object3 = (String)object.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        Object object4 = (ChangeLogParameters)object.getDependency(ChangeLogParameters.class);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)object.getDependency(DatabaseChangeLog.class);
        Database database = (Database)object.getDependency(Database.class);
        Contexts contexts = object4.getContexts();
        LabelExpression labelExpression = object4.getLabels();
        ChangeExecListener changeExecListener = (ChangeExecListener)object.getDependency(ChangeExecListener.class);
        List list = database.getRanChangeSetList();
        boolean bl2 = (Boolean)object.getArgumentValue(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK);
        object = (String)object.getArgumentValue(DEPLOYMENT_ID_ARG);
        if (object2 == null || !((Boolean)object2).booleanValue()) {
            object2 = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-update-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException((String)object2, Level.WARNING);
        }
        Scope.getCurrentScope().addMdcValue("rollbackScript", (String)object3);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", JdbcConnection.sanitizeUrl((String)database.getConnection().getURL()));
        Scope.getCurrentScope().addMdcValue("rollbackOneUpdateForce", String.valueOf(object2));
        if (object == null) {
            object = this.findLatestDeploymentId(database);
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + (String)object + "'");
        } else {
            this.validateDeploymentId((String)object, list);
        }
        Scope.getCurrentScope().addMdcValue("deploymentId", (String)object);
        try {
            databaseChangeLog.validate(database, contexts, labelExpression);
            object2 = new DeploymentIdFilter((String)object, database, list, databaseChangeLog, COMMAND_NAME[0]);
            list = this.createChangeLogIterator(list, (ChangeSetFilter)object2, databaseChangeLog, contexts, labelExpression, database);
            ArrayList<ChangesetsRolledback.ChangeSet> arrayList = new ArrayList<ChangesetsRolledback.ChangeSet>();
            if (object3 == null) {
                this.validateDeploymentIdFilter((String)object, (DeploymentIdFilter)object2);
                list.run((ChangeSetVisitor)this.createRollbackVisitor(arrayList, database, changeExecListener), new RuntimeEnvironment(database, contexts, labelExpression));
            } else {
                this.executeRollbackScript((String)object3, (String)object, contexts, labelExpression, databaseChangeLog, (List<ChangesetsRolledback.ChangeSet>)arrayList, (ChangeLogIterator)list, (ChangeLogParameters)object4, database, changeExecListener);
                this.removeRunStatus((ChangeLogIterator)list, contexts, labelExpression, database);
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executed rollback script ".concat(String.valueOf(object3)));
            }
            object2 = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            object3 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            catch (Throwable throwable) {
                object4 = throwable;
                object3 = throwable;
                throw object4;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
            if (bl2) {
                Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback(arrayList), false);
            }
            this.logSuccess(databaseChangeLog);
            commandResultsBuilder.addResult("processedChangesets", arrayList);
            commandResultsBuilder.addResult("statusCode", (Object)0);
        }
        catch (LiquibaseException liquibaseException) {
            commandResultsBuilder.addResult("statusCode", (Object)1);
            this.handleRollbackError((Exception)((Object)liquibaseException), (String)object, changeExecListener, databaseChangeLog, database);
        }
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-update executed for " + database.getConnection().getConnectionUserName() + "@" + database.getConnection().getURL());
    }

    public String findLatestDeploymentId(Database object) {
        object = ((AbstractChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(object)).getLastDeploymentId();
        if (object == null) {
            throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
        }
        return object;
    }

    private void validateDeploymentId(String string, List<RanChangeSet> object) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            RanChangeSet ranChangeSet = (RanChangeSet)object.next();
            if (!string.equals(ranChangeSet.getDeploymentId())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            object = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), string);
            throw new LiquibaseException("\n".concat(String.valueOf(object)));
        }
    }

    private void validateDeploymentIdFilter(String string, DeploymentIdFilter object) {
        if (!((DeploymentIdFilter)((Object)object)).getNoInverseChangeSets().isEmpty()) {
            string = "\n\nThere are changesets associated with the deployment ID '" + string + "' which cannot be rolled back.\nNo rollback was performed.\n";
            string = string + "\nChangesets which cannot be rolled back:\n";
            for (Map.Entry<String, ChangeSet> entry : ((DeploymentIdFilter)((Object)object)).getNoInverseChangeSets().entrySet()) {
                string = string + entry.getKey();
                string = string + "\n";
            }
            throw new LiquibaseException("\n".concat(String.valueOf(string)));
        }
        if (((DeploymentIdFilter)((Object)object)).isEmpty()) {
            string = "\n\nThere are no changesets associated with the deployment ID '" + string + "'.\nPlease check your parameters.  No rollback was performed.\n";
            throw new LiquibaseException("\n".concat(String.valueOf(string)));
        }
    }

    private void handleRollbackError(Exception exception, String string, ChangeExecListener changeExecListener, DatabaseChangeLog databaseChangeLog, Database database) {
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Throwable throwable = exception.getCause();
        Throwable throwable2 = null;
        try (Object object = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");){
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throwable2 = throwable3;
            throw throwable4;
        }
        if (throwable instanceof RollbackImpossibleException) {
            object = "\nError executing rollback:\nThe rollback for deployment ID '" + string + "' has at least one changeset without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
            logger.severe((String)object, (Throwable)exception);
            if (changeExecListener != null) {
                changeExecListener.runFailed(null, databaseChangeLog, database, exception);
            }
            throw new LiquibaseException((String)object, (Throwable)exception);
        }
        logger.severe("\nError executing rollback for the deployment ID '" + string + "'.");
        throw new LiquibaseException("\nError executing rollback for the deployment ID '" + string + "':\n" + exception.getMessage(), (Throwable)exception);
    }

    private void executeRollbackScript(String string, String string2, Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog databaseChangeLog, List<ChangesetsRolledback.ChangeSet> list, ChangeLogIterator changeLogIterator, ChangeLogParameters changeLogParameters, Database database, ChangeExecListener changeExecListener) {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        string = this.getRollbackScriptContents(string, executor.toString(), changeLogParameters, databaseChangeLog);
        databaseChangeLog = this.buildRawSQLChange(string);
        try {
            this.updateListener(changeLogIterator, contexts, labelExpression, database, changeExecListener, list, RollbackOneUpdateCommandStep$ListenerStatus.WILL_ROLLBACK, null);
            Scope.getCurrentScope().getUI().sendMessage("Rolling back deploymentId: ".concat(String.valueOf(string2)));
            executor.execute((Change)databaseChangeLog);
            this.updateListener(changeLogIterator, contexts, labelExpression, database, changeExecListener, list, RollbackOneUpdateCommandStep$ListenerStatus.ROLLED_BACK, null);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error executing rollback script: " + databaseException.getMessage());
            this.updateListener(changeLogIterator, contexts, labelExpression, database, changeExecListener, list, RollbackOneUpdateCommandStep$ListenerStatus.ROLLBACK_FAILED, (Exception)((Object)databaseException));
            throw new LiquibaseException("\nError executing rollback for the deploymentId '" + string2 + "':\n" + databaseException.getMessage(), (Throwable)databaseException);
        }
        database.commit();
        if (string.length() == 0) {
            Scope.getCurrentScope().getUI().sendMessage("No rollback logic defined in empty rollback script. Changesets have been removed from the DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    private void updateListener(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression, Database database, ChangeExecListener changeExecListener, List<ChangesetsRolledback.ChangeSet> list, RollbackOneUpdateCommandStep$ListenerStatus rollbackOneUpdateCommandStep$ListenerStatus, Exception exception) {
        changeLogIterator.run((ChangeSetVisitor)new RollbackOneUpdateCommandStep$1(this, database, changeExecListener, list, changeExecListener, rollbackOneUpdateCommandStep$ListenerStatus, list, exception), new RuntimeEnvironment(database, contexts, labelExpression));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        DEPLOYMENT_ID_ARG = commandBuilder.argument("deploymentId", String.class).description("The deployment ID of the update to rollback").build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
        SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK = commandBuilder.argument("shouldLogMdcChangesetsRolledBack", Boolean.class).hidden().defaultValue((Object)Boolean.TRUE).build();
    }
}

