/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SinglePendingChangeSetFilter;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsUpdated;

public class UpdateOneChangeSetCommandStep
extends AbstractCommandStep
implements CleanUpCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH;
    public static final CommandArgumentDefinition<Boolean> FORCE;
    public static final CommandArgumentDefinition<Boolean> OVERRIDE_CHANGESET_IGNORE_FLAG;
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Boolean force;
    private static final ResourceBundle coreBundle;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Runs single changeset"));
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeLogParameters.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Object object = (Writer)commandScope.getDependency(Writer.class);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)commandScope.getDependency(ChangeLogParameters.class);
        Contexts contexts = changeLogParameters.getContexts();
        LabelExpression labelExpression = changeLogParameters.getLabels();
        this.setup(commandScope, (Writer)object);
        Scope.getCurrentScope().addMdcValue("commandLabelFilter", contexts.toString());
        Scope.getCurrentScope().addMdcValue("commandContextFilter", labelExpression.toString());
        this.checkLiquibaseTables();
        databaseChangeLog.validate(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels());
        object = new SinglePendingChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, databaseChangeLog);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(new ContextChangeSetFilter(contexts));
        arrayList.add(new LabelChangeSetFilter(labelExpression));
        if (!((Boolean)commandScope.getArgumentValue(OVERRIDE_CHANGESET_IGNORE_FLAG)).booleanValue()) {
            arrayList.add(new IgnoreChangeSetFilter());
        }
        commandScope = new ChangeLogIterator(databaseChangeLog, arrayList);
        object = new DefaultChangeExecListener(new ChangeExecListener[0]);
        try {
            UpdateOneChangeSetCommandStep updateOneChangeSetCommandStep = this;
            updateOneChangeSetCommandStep.setupExecutionServices(updateOneChangeSetCommandStep.database);
            commandResultsBuilder.addResult("defaultChangeExecListener", object);
            this.printIgnoredChangesets((ChangeLogIterator)commandScope, changeLogParameters);
            databaseChangeLog = new UpdateVisitor(this.database, (ChangeExecListener)object, new ShouldRunChangeSetFilter(this.database, true));
            commandScope.run((ChangeSetVisitor)databaseChangeLog, new RuntimeEnvironment(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels()));
            this.logDeploymentOutcomeMdc(true, (DefaultChangeExecListener)object);
            commandResultsBuilder.addResult("statusCode", (Object)0);
        }
        catch (LiquibaseException liquibaseException) {
            try {
                this.logDeploymentOutcomeMdc(false, (DefaultChangeExecListener)object);
                throw new RuntimeException(liquibaseException);
            }
            catch (Throwable throwable) {
                try {
                    LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
                    throw throwable;
                }
                catch (LockException lockException) {
                    logger.severe(coreBundle.getString("could.not.release.lock"), (Throwable)lockException);
                }
                throw throwable;
            }
        }
        try {
            LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
            return;
        }
        catch (LockException lockException) {
            logger.severe(coreBundle.getString("could.not.release.lock"), (Throwable)lockException);
            return;
        }
    }

    private void printIgnoredChangesets(ChangeLogIterator object, ChangeLogParameters changeLogParameters2) {
        StatusVisitor statusVisitor = new StatusVisitor(this.database);
        object.run((ChangeSetVisitor)statusVisitor, new RuntimeEnvironment(this.database, changeLogParameters2.getContexts(), changeLogParameters2.getLabels()));
        for (ChangeLogParameters changeLogParameters2 : statusVisitor.getChangeSetsToSkip()) {
            statusVisitor = changeLogParameters2.getChangeSet();
            boolean bl2 = changeLogParameters2.getFilterResults().stream().anyMatch(changeSetFilterResult -> changeSetFilterResult.getFilter().isAssignableFrom(IgnoreChangeSetFilter.class));
            boolean bl3 = changeLogParameters2.getFilterResults().stream().noneMatch(changeSetFilterResult -> changeSetFilterResult.getFilter().isAssignableFrom(SinglePendingChangeSetFilter.class));
            if (!bl2 || !bl3) continue;
            Scope.getCurrentScope().getUI().sendMessage("INFO: The changeset (id: " + statusVisitor.getId() + ", author: " + statusVisitor.getAuthor() + ", filepath: " + statusVisitor.getFilePath() + " was skipped because the \"ignore=true\" attribute was set.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logDeploymentOutcomeMdc(boolean bl2, DefaultChangeExecListener object) {
        List list;
        block37: {
            list = Collections.emptyList();
            try {
                if (object != null) {
                    list = object.getDeployedChangeSets();
                }
            }
            catch (Exception exception) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to calculate deployed changeset count for MDC", (Throwable)exception);
            }
            object = new ChangesetsUpdated(list);
            list = Scope.getCurrentScope().addMdcValue("deploymentOutcomeCount", String.valueOf(list.size()));
            Throwable throwable = null;
            try {
                Throwable throwable2 = null;
                try (MdcObject mdcObject = Scope.getCurrentScope().addMdcValue("deploymentOutcome", bl2 ? "success" : "fail");){
                    object = Scope.getCurrentScope().addMdcValue("changesetsUpdated", (CustomMdcObject)object);
                    Throwable throwable3 = null;
                    try {
                        String string = "Update command completed successfully.";
                        String string2 = "Update command encountered an exception.";
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(bl2 ? string : string2);
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable5 = throwable4;
                        throwable3 = throwable4;
                        throw throwable5;
                    }
                    finally {
                        if (object != null) {
                            if (throwable3 != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    object = throwable5;
                    throwable2 = throwable5;
                    throw object;
                }
                if (list == null) return;
                if (throwable == null) break block37;
            }
            catch (Throwable throwable6) {
                try {
                    Throwable throwable10 = throwable6;
                    throwable = throwable6;
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    if (list == null) throw throwable11;
                    if (throwable == null) {
                        list.close();
                        throw throwable11;
                    }
                    try {
                        list.close();
                        throw throwable11;
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                        throw throwable11;
                    }
                }
            }
            try {
                list.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        list.close();
    }

    private void setup(CommandScope commandScope, Writer writer) {
        this.database = (Database)commandScope.getDependency(Database.class);
        this.changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID);
        this.changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR);
        this.changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH);
        this.force = (Boolean)commandScope.getArgumentValue(FORCE);
        Scope.getCurrentScope().addMdcValue("updateOneChangesetForce", String.valueOf(this.force));
        this.checkArgs(writer);
    }

    private void checkArgs(Writer object) {
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(coreBundle.getString("id.author.path.required"));
        }
        if (!(object != null || this.force != null && this.force.booleanValue())) {
            object = "\nWARNING: Targeted update of this changeset may result in unexpected outcomes.  To review the update\nSQL before executing it, please run 'update-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException((String)object, Level.WARNING);
        }
    }

    public void cleanUp(CommandResultsBuilder commandResultsBuilder) {
        LockServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
    }

    private void setupExecutionServices(Database database) {
        LockServiceFactory.getInstance().getLockService(database).waitForLock();
        database = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
        database.init();
        database.generateDeploymentId();
        Scope.getCurrentScope().addMdcValue("deploymentId", database.getDeploymentId());
    }

    protected void checkLiquibaseTables() {
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).init();
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
        FORCE = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        OVERRIDE_CHANGESET_IGNORE_FLAG = commandBuilder.argument("overrideChangesetIgnoreFlag", Boolean.class).description("If true, the ignore flag on the changeset will be ignored, and the changeset will be run regardless of the ignore flag.").defaultValue((Object)Boolean.FALSE).hidden().build();
    }
}

