/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.provider;

import com.datical.liquibase.ext.flow.provider.AbstractFlowGlobalArgsValueProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import liquibase.Scope;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;

public class ActionGlobalArgsValueProvider
extends AbstractFlowGlobalArgsValueProvider {
    private int precedence = 380;
    private Handler fileHandler;
    private Handler previousHandler;

    public ActionGlobalArgsValueProvider(Map<String, Object> object) {
        super((Map<String, Object>)object);
        long l2 = ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getProviders().stream().filter(ActionGlobalArgsValueProvider.class::isInstance).count();
        if (l2 > 0L) {
            this.precedence = (int)((long)this.precedence + l2);
        }
        if (object != null) {
            try {
                Object object2 = (String)this.getValueWithFuzzyMatching("loglevel", (Map<String, Object>)object);
                object2 = object2 != null ? Level.parse((String)object2) : Level.INFO;
                object = (String)this.getValueWithFuzzyMatching("logfile", (Map<String, Object>)object);
                this.configureLogging((Level)object2, (String)object);
                return;
            }
            catch (IOException iOException) {
                Scope.getCurrentScope().getLog(ActionGlobalArgsValueProvider.class).info("Unable to configuration logging for flow command", (Throwable)iOException);
            }
        }
    }

    private Object getValueWithFuzzyMatching(String string, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string2 == null || !(string2 = string2.replace("-", "")).equalsIgnoreCase(string = string.replace("-", ""))) continue;
            return map.get(entry.getKey());
        }
        return null;
    }

    public void removeHandler() {
        if (this.fileHandler != null) {
            Logger logger = Logger.getLogger("");
            this.fileHandler.close();
            logger.removeHandler(this.fileHandler);
            if (this.previousHandler != null) {
                logger.addHandler(this.previousHandler);
            }
        }
    }

    private void configureLogging(Level level, String handlerArray) {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        LogService logService = (LogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        Logger logger = Logger.getLogger("liquibase");
        if (logService instanceof JavaLogService) {
            ((JavaLogService)logService).setParent(logger);
        }
        logger = Logger.getLogger("");
        if (handlerArray != null) {
            handlerArray = pathHandlerFactory.openResourceOutputStream((String)handlerArray, new OpenOptions().setAppend(true));
            this.fileHandler = new StreamHandler((OutputStream)handlerArray, new SimpleFormatter());
            JavaLogService.setFormatterOnHandler((LogService)logService, (Handler)this.fileHandler);
            handlerArray = logger.getHandlers();
            this.previousHandler = handlerArray[handlerArray.length - 1];
            if (!(this.previousHandler instanceof ConsoleHandler)) {
                logger.removeHandler(this.previousHandler);
            } else {
                this.previousHandler = null;
            }
            logger.addHandler(this.fileHandler);
            this.fileHandler.setLevel(level);
        }
    }

    public ActionGlobalArgsValueProvider(Map<String, Object> map, int n2) {
        super(map);
        this.precedence += n2;
    }

    public int getPrecedence() {
        return this.precedence;
    }
}

