/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured.mdc.customobjects;

import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowAction;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowFilesNested;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowStage;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.IncludeFile;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.Includes;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.NestedFile;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.Stages;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.resource.Resource;

public class FlowFileRoot
implements CustomMdcObject {
    public static final String END_STAGE = "endStage";
    private String name;
    private String path;
    private Map<String, Object> userMetadata;
    private Stages stages;
    private Includes includedFiles;
    private LinkedHashMap<String, Object> globalVariables;
    private FlowFilesNested flowFilesNested;

    public FlowFileRoot() {
    }

    public FlowFileRoot(String object, FlowFileLoad flowFileLoad, Map<String, Stage> map, Stage stage) {
        this.setName((String)object);
        FlowFileRoot flowFileRoot = this;
        flowFileRoot.setPath(flowFileRoot.getResourcePath(flowFileLoad.resource));
        this.setUserMetadata(flowFileLoad.flowFile.getUserMetadata());
        this.stages = new Stages();
        object = new AtomicInteger(1);
        map.forEach((arg_0, arg_1) -> this.lambda$new$0((AtomicInteger)object, arg_0, arg_1));
        this.addEndStage(stage, (AtomicInteger)object);
        if (flowFileLoad.includes != null) {
            this.includedFiles = new Includes();
            this.includedFiles.setFileCount(flowFileLoad.includes.size());
            object = new AtomicInteger(1);
            flowFileLoad.includes.forEach((arg_0, arg_1) -> this.lambda$new$1((AtomicInteger)object, arg_0, arg_1));
        }
        if (flowFileLoad.globalVariables != null) {
            this.setGlobalVariables(flowFileLoad.globalVariables);
        }
        this.loadNestedFlowFiles(flowFileLoad);
    }

    private void loadNestedFlowFiles(FlowFileLoad flowFileLoad) {
        if (flowFileLoad.nestedFlowFiles == null) {
            this.flowFilesNested = new FlowFilesNested();
            this.flowFilesNested.setFileCount(0);
            return;
        }
        this.flowFilesNested = new FlowFilesNested();
        this.flowFilesNested.setFileCount(flowFileLoad.nestedFlowFiles.size());
        AtomicInteger atomicInteger = new AtomicInteger(1);
        flowFileLoad.nestedFlowFiles.forEach((string, string2) -> {
            NestedFile nestedFile = new NestedFile();
            new NestedFile().name = string;
            nestedFile.rootStage = string2;
            try {
                nestedFile.path = this.getResourcePath(FlowFileHelper.determineResource(string));
            }
            catch (IOException iOException) {}
            this.flowFilesNested.getFile().put(Integer.toString(atomicInteger.getAndIncrement()), nestedFile);
        });
    }

    private FlowStage createFlowStage(String string, Stage stage) {
        FlowStage flowStage = new FlowStage();
        flowStage.setName(string);
        flowStage.setUserMetadata(stage != null ? stage.getUserMetadata() : null);
        if (stage != null && stage.getActions() != null) {
            this.createFlowAction(stage, flowStage);
        }
        return flowStage;
    }

    private void createFlowAction(Stage stage, FlowStage flowStage) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        flowStage.setStageVars(stage.getVariables());
        stage.getActions().forEach(action -> {
            FlowAction flowAction = new FlowAction();
            flowAction.setType(action.getType());
            flowAction.setCommand(action.getCommand());
            flowAction.setUserMetadata(action.getUserMetadata());
            flowStage.addAction(Integer.toString(atomicInteger.getAndIncrement()), flowAction);
        });
    }

    private void addEndStage(Stage object, AtomicInteger atomicInteger) {
        if (object != null) {
            object = new FlowStage();
            ((FlowStage)object).setName(END_STAGE);
            this.stages.getStage().put(Integer.toString(atomicInteger.getAndIncrement()), (FlowStage)object);
        }
    }

    private String getResourcePath(Resource resource) {
        if (resource != null) {
            return resource.getUri().toString().replace("file://", "");
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public Stages getStages() {
        return this.stages;
    }

    public void setStages(Stages stages) {
        this.stages = stages;
    }

    public Includes getIncludedFiles() {
        return this.includedFiles;
    }

    public void setIncludedFiles(Includes includes) {
        this.includedFiles = includes;
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setGlobalVariables(LinkedHashMap<String, Object> linkedHashMap) {
        this.globalVariables = linkedHashMap;
    }

    public FlowFilesNested getFlowFilesNested() {
        return this.flowFilesNested;
    }

    public void setFlowFilesNested(FlowFilesNested flowFilesNested) {
        this.flowFilesNested = flowFilesNested;
    }

    public Map<String, Object> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, Object> map) {
        this.userMetadata = map;
    }

    private /* synthetic */ void lambda$new$1(AtomicInteger atomicInteger, String string, Resource resource) {
        IncludeFile includeFile = new IncludeFile();
        new IncludeFile().name = string;
        includeFile.path = this.getResourcePath(resource);
        this.includedFiles.getFile().put(Integer.toString(atomicInteger.getAndIncrement()), includeFile);
    }

    private /* synthetic */ void lambda$new$0(AtomicInteger atomicInteger, String object, Stage stage) {
        object = this.createFlowStage((String)object, stage);
        this.stages.getStage().put(Integer.toString(atomicInteger.getAndIncrement()), (FlowStage)object);
    }
}

