/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.reports.DatabaseObjectReportValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import liquibase.diff.DiffResult;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.DatabaseObjectCollectionComparator;
import liquibase.diff.output.report.DiffToReport;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class TextDriftReport
extends DiffToReport {
    final DatabaseObjectCollectionComparator comparator = new DatabaseObjectCollectionComparator();

    public TextDriftReport(DiffResult diffResult) {
        super(diffResult, null);
    }

    private TreeSet<Class<? extends DatabaseObject>> setupComparedTypes() {
        TreeSet<Class<? extends DatabaseObject>> treeSet = new TreeSet<Class<? extends DatabaseObject>>(Comparator.comparing(Class::getSimpleName));
        treeSet.addAll(this.diffResult.getCompareControl().getComparedTypes());
        return treeSet;
    }

    public List<DatabaseObjectReportValue> getMissingValues() {
        Object object = this.setupComparedTypes();
        ArrayList<DatabaseObjectReportValue> arrayList = new ArrayList<DatabaseObjectReportValue>();
        object = ((TreeSet)object).iterator();
        while (object.hasNext()) {
            Object object2 = (Class)object.next();
            if (object2.equals(Schema.class) && !this.diffResult.getComparisonSnapshot().getDatabase().supportsSchemas()) continue;
            TextDriftReport textDriftReport = this;
            if (((DatabaseObjectReportValue)(object2 = new DatabaseObjectReportValue(this.getTypeName((Class)object2), textDriftReport.populateDatabaseObjectReportValue(textDriftReport.diffResult.getMissingObjects((Class)object2, (Comparator)this.comparator))))).getResults().isEmpty()) continue;
            arrayList.add((DatabaseObjectReportValue)object2);
        }
        return arrayList;
    }

    public List<DatabaseObjectReportValue> getUnexpectedValues() {
        Object object = this.setupComparedTypes();
        ArrayList<DatabaseObjectReportValue> arrayList = new ArrayList<DatabaseObjectReportValue>();
        object = ((TreeSet)object).iterator();
        while (object.hasNext()) {
            Object object2 = (Class)object.next();
            if (object2.equals(Schema.class) && !this.diffResult.getComparisonSnapshot().getDatabase().supportsSchemas()) continue;
            TextDriftReport textDriftReport = this;
            if (((DatabaseObjectReportValue)(object2 = new DatabaseObjectReportValue(this.getTypeName((Class)object2), textDriftReport.populateDatabaseObjectReportValue(textDriftReport.diffResult.getUnexpectedObjects((Class)object2, (Comparator)this.comparator))))).getResults().isEmpty()) continue;
            arrayList.add((DatabaseObjectReportValue)object2);
        }
        return arrayList;
    }

    public List<DatabaseObjectReportValue> getChangedValues() {
        Object object = this.setupComparedTypes();
        ArrayList<DatabaseObjectReportValue> arrayList = new ArrayList<DatabaseObjectReportValue>();
        object = ((TreeSet)object).iterator();
        while (object.hasNext()) {
            Object object2 = (Class)object.next();
            if (object2.equals(Schema.class) && !this.diffResult.getComparisonSnapshot().getDatabase().supportsSchemas()) continue;
            TextDriftReport textDriftReport = this;
            if (((DatabaseObjectReportValue)(object2 = new DatabaseObjectReportValue(this.getTypeName((Class)object2), textDriftReport.populateDatabaseObjectReportValue(textDriftReport.diffResult.getChangedObjects((Class)object2, (Comparator)this.comparator))))).getResults().isEmpty()) continue;
            arrayList.add((DatabaseObjectReportValue)object2);
        }
        return arrayList;
    }

    private List<String> populateDatabaseObjectReportValue(Set<? extends DatabaseObject> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Schema schema = null;
        if (object.isEmpty()) {
            return arrayList;
        }
        object = object.iterator();
        while (object.hasNext()) {
            DatabaseObject databaseObject = (DatabaseObject)object.next();
            if (!this.diffResult.getReferenceSnapshot().getSnapshotControl().shouldInclude(databaseObject)) continue;
            if (this.getIncludeSchema() && databaseObject.getSchema() != null && (schema == null || !schema.equals((Object)databaseObject.getSchema()))) {
                schema = databaseObject.getSchema();
                String string = databaseObject.getSchema().getName();
                if (string == null) {
                    string = databaseObject.getSchema().getCatalogName();
                }
                string = this.includeSchemaComparison(string);
                arrayList.add(String.format("Schema: %s", string));
            }
            arrayList.add(databaseObject.toString());
        }
        return arrayList;
    }

    private List<String> populateDatabaseObjectReportValue(Map<? extends DatabaseObject, ObjectDifferences> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object.isEmpty()) {
            return arrayList;
        }
        for (Map.Entry entry : object.entrySet()) {
            if (!((ObjectDifferences)entry.getValue()).hasDifferences()) continue;
            for (Difference difference : ((ObjectDifferences)entry.getValue()).getDifferences()) {
                arrayList.add(String.format("%s: %s", entry.getKey(), difference.toString()));
            }
        }
        return arrayList;
    }
}

