/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageBodyStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropPackageBody", description="Drops an existing package body", priority=101, appliesTo={"packageBody"})
public class DropPackageBodyChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String packageBodyName;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    @DatabaseChangeProperty(mustEqualExisting="packageBody.catalog", description="Name of the database catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="packageBody.schema", description="Name of the database schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="packageBody", description="Name of the package body to drop")
    public String getPackageBodyName() {
        return this.packageBodyName;
    }

    public void setPackageBodyName(String string) {
        this.packageBodyName = string;
    }

    public String getConfirmationMessage() {
        return "Package body " + this.getPackageBodyName() + " dropped";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropPackageBodyStatement(this.getCatalogName(), this.getSchemaName(), this.getPackageBodyName())};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

