/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import java.io.File;
import java.security.SecureRandom;
import java.util.Random;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.CommandExecutionException;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

public class NativeToolFileCreator {
    public static final Pattern EXTENSION_PATTERN = Pattern.compile(".*(\\..*)$");
    private final ChangeSet changeSet;
    private final String tempFilenameOverride;
    private final String pathOverride;
    private final boolean overwriteFile;
    private final boolean keepFile;
    private final String integrationDisplayName;
    private final String keepTempOverwriteConfigKey;

    public NativeToolFileCreator(ChangeSet changeSet, String string, String string2, boolean bl2, boolean bl3, String string3, String string4) {
        this.changeSet = changeSet;
        this.tempFilenameOverride = string;
        this.pathOverride = string2;
        this.overwriteFile = bl2;
        this.keepFile = bl3;
        this.integrationDisplayName = string3;
        this.keepTempOverwriteConfigKey = string4;
    }

    public File generateTemporaryFile(NativeToolFileCreator$FileTypeEnum nativeToolFileCreator$FileTypeEnum) {
        return this.generateTemporaryFile(nativeToolFileCreator$FileTypeEnum, true);
    }

    public File generateTemporaryFile(NativeToolFileCreator$FileTypeEnum nativeToolFileCreator$FileTypeEnum, boolean bl2) {
        Object object;
        Object object2 = Scope.getCurrentScope().getLog(this.getClass());
        String string = "liquibase-" + nativeToolFileCreator$FileTypeEnum.toString() + "-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-";
        if (StringUtil.isNotEmpty((String)this.tempFilenameOverride)) {
            string = this.tempFilenameOverride;
        }
        string = FilenameUtil.sanitizeFileName((String)string);
        object2.info("Creating temporary " + (Object)((Object)nativeToolFileCreator$FileTypeEnum) + " file for '" + string + "'");
        Object object3 = object = bl2 ? nativeToolFileCreator$FileTypeEnum.extension : "";
        if (StringUtil.isEmpty((String)this.pathOverride)) {
            object2 = System.getProperty("java.io.tmpdir");
            if (StringUtil.isEmpty((String)this.tempFilenameOverride)) {
                return this.deleteFileOnExitIfNeeded(File.createTempFile(string, nativeToolFileCreator$FileTypeEnum.extension), this.keepFile);
            }
            File file = new File((String)object2, this.tempFilenameOverride + (String)object);
            NativeToolFileCreator nativeToolFileCreator = this;
            return nativeToolFileCreator.deleteFileOnExitIfNeeded(nativeToolFileCreator.safelyCreateNewFile(file, this.overwriteFile, nativeToolFileCreator$FileTypeEnum), this.keepFile);
        }
        object2 = new File(this.pathOverride);
        boolean bl3 = ((File)object2).mkdirs();
        if (!this.keepFile && bl3) {
            ((File)object2).deleteOnExit();
        }
        if (StringUtil.isEmpty((String)this.tempFilenameOverride)) {
            object = new SecureRandom();
            object = new File(this.pathOverride, string + ((Random)object).nextLong() + nativeToolFileCreator$FileTypeEnum.extension);
            NativeToolFileCreator nativeToolFileCreator = this;
            return nativeToolFileCreator.deleteFileOnExitIfNeeded(nativeToolFileCreator.safelyCreateNewFile((File)object, this.overwriteFile, nativeToolFileCreator$FileTypeEnum), this.keepFile);
        }
        object = new File(this.pathOverride, this.tempFilenameOverride + (String)object);
        NativeToolFileCreator nativeToolFileCreator = this;
        return nativeToolFileCreator.deleteFileOnExitIfNeeded(nativeToolFileCreator.safelyCreateNewFile((File)object, this.overwriteFile, nativeToolFileCreator$FileTypeEnum), this.keepFile);
    }

    private File safelyCreateNewFile(File file, Boolean bl2, NativeToolFileCreator$FileTypeEnum nativeToolFileCreator$FileTypeEnum) {
        if (!file.exists()) {
            return this.createNewFile(file);
        }
        if (file.exists() && bl2 == null) {
            throw new CommandExecutionException("ERROR: Specified " + this.integrationDisplayName + " " + nativeToolFileCreator$FileTypeEnum.name() + " file " + file.getAbsolutePath() + " already exists, and " + this.keepTempOverwriteConfigKey + "=NULL. It is unclear whether the file should be overwritten. To run this job, either adjust file name or path, or set " + this.keepTempOverwriteConfigKey + "=TRUE.");
        }
        if (file.exists() && !bl2.booleanValue()) {
            throw new CommandExecutionException("ERROR: Specified " + this.integrationDisplayName + " " + nativeToolFileCreator$FileTypeEnum.name() + " file " + file.getAbsolutePath() + " already exists, and " + this.keepTempOverwriteConfigKey + "=FALSE. To run this job, either adjust file name or path, or set " + this.keepTempOverwriteConfigKey + "=TRUE.");
        }
        Scope.getCurrentScope().getUI().sendMessage("WARNING: Specified " + this.integrationDisplayName + " " + nativeToolFileCreator$FileTypeEnum.name() + " file " + file.getAbsolutePath() + " already existed, and was overwritten.");
        if (file.delete()) {
            return this.createNewFile(file);
        }
        throw new CommandExecutionException("Failed to create file " + file.getAbsolutePath() + " after deleting existing file.");
    }

    private File createNewFile(File file) {
        if (file.createNewFile()) {
            return file;
        }
        throw new CommandExecutionException("Failed to create file " + file.getAbsolutePath() + ".");
    }

    private File deleteFileOnExitIfNeeded(File file, Boolean bl2) {
        if (!bl2.booleanValue()) {
            file.deleteOnExit();
        }
        return file;
    }
}

