/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.SqlcmdConfiguration;
import com.datical.liquibase.ext.config.SqlcmdConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.NativeExecutorRunner$ConfigFile;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import com.datical.liquibase.ext.tools.SqlPlusRunner;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlcmdRunner
extends NativeExecutorRunner {
    private File outFile = null;
    private Boolean keepTempFile = Boolean.FALSE;
    private Boolean tempOverwrite = Boolean.TRUE;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private String catalogName;
    private Integer timeout;
    private File sqlcmdExec;
    private static final String EXECUTABLE_NAME = "sqlcmd";

    public SqlcmdRunner(ChangeSet changeSet, Sql[] sqlArray) {
        super(sqlArray);
        this.changeSet = changeSet;
        this.setTimeout("1800");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    protected List<String> createFinalCommandArray(Database database) {
        this.loadSqlcmdProperties();
        List list = super.createFinalCommandArray(database);
        String string = this.getCatalogName() != null ? this.getCatalogName() : database.getDefaultCatalogName();
        try {
            if (string != null && !((MSSQLDatabase)database).isAzureDb()) {
                this.writeSql(string);
            } else {
                this.writeSql(null);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)SqlcmdConfiguration.TEMP_KEEP.getCurrentValue();
        }
        list.add("-S");
        list.add(this.getDatabaseHostname(database));
        String string2 = "";
        Object object = "";
        DatabaseConnection databaseConnection = database.getConnection();
        if (databaseConnection instanceof ProJdbcConnection) {
            object = (ProJdbcConnection)databaseConnection;
            string2 = ((ProJdbcConnection)((Object)object)).getUsername();
            if (string2 == null) {
                string2 = databaseConnection.getConnectionUserName();
            }
            string2 = StringUtil.trimToEmpty((String)string2);
            if ((object = StringUtil.trimToEmpty((String)((ProJdbcConnection)((Object)object)).getPassword())).equals("")) {
                string2 = "";
            }
        }
        this.addCredentials(list, string2, (String)object);
        if (((MSSQLDatabase)database).isAzureDb()) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database is AzureDB");
            list.add("-d");
            list.add(string);
        }
        if (this.isActiveDirectoryAuthentication(database)) {
            list.add("-G");
        }
        if (this.outFile != null) {
            list.add("-i");
            list.add(this.outFile.getAbsolutePath());
        }
        list.add("-b");
        list.add("-e");
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        object = StringUtil.join((Collection)list, (String)" ").replaceAll("^(.*?) (.*?) -U (.*?) -P (.*?) (.*)", "$1 $2 -U ****** -P ****** $5");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD command:\n".concat(String.valueOf(object)));
        return list;
    }

    private void addCredentials(List<String> list, String string, String string2) {
        if (StringUtil.isEmpty((String)string) || StringUtil.isEmpty((String)string2)) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection is missing username and/or password. Assuming integratedSecurity.");
            list.add("-E");
            return;
        }
        Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection has both username and password. Adding -U and -P to commandArray.");
        list.add("-U");
        list.add(string);
        list.add("-P");
        list.add(string2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(Database object) {
        try {
            this.finalCommandArray = this.createFinalCommandArray((Database)object);
            super.executeCommand(object);
            if (this.outFile == null) return;
        }
        catch (TimeoutException timeoutException) {
            try {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.processResult(0, null, null, (Database)object);
                object = timeoutException.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlcmd executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlcmd.conf file, the LIQUIBASE_SQLCMD_TIMEOUT Environment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sqlcmd-integration.html." + System.lineSeparator();
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning((String)object);
                throw new LiquibaseException((Throwable)timeoutException);
                catch (IllegalArgumentException illegalArgumentException) {
                    throw illegalArgumentException;
                }
                catch (Exception exception) {
                    object = this.tempPath;
                    String string = exception.getMessage();
                    try {
                        File file;
                        if (this.logFile == null) throw new DatabaseException(string, (Throwable)exception);
                        if (object == null) {
                            object = System.getProperty("java.io.tmpdir");
                        }
                        if (!(file = new File((String)object, this.logFile)).exists()) throw new DatabaseException(string, (Throwable)exception);
                        string = FileUtil.getContents((File)file);
                        throw new DatabaseException(string, (Throwable)exception);
                    }
                    catch (Exception exception2) {
                        Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("Error reading logfile '" + new File((String)object, this.logFile) + this.logFile + "' " + exception.getMessage());
                    }
                    throw new DatabaseException(string, (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                if (this.outFile == null) throw throwable;
                if (!this.outFile.exists()) throw throwable;
                if (this.keepTempFile == null) throw throwable;
                if (this.keepTempFile == false) throw throwable;
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
                throw throwable;
            }
        }
        if (!this.outFile.exists()) return;
        if (this.keepTempFile == null) return;
        if (this.keepTempFile == false) return;
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
    }

    protected void processResult(int n2, String string, String string2, Database database) {
        if (n2 != 0 && !StringUtil.isEmpty((String)string2)) {
            String string3 = this.getCommandString() + " returned a code of " + n2 + "\n" + string2;
            throw new UnexpectedLiquibaseException(string3);
        }
        super.processResult(n2, string, string2, database);
    }

    protected ExecuteShellCommandChange.StreamGobbler createErrorGobbler(InputStream inputStream, OutputStream outputStream) {
        return new ExecuteShellCommandChange.StreamGobbler((ExecuteShellCommandChange)this, inputStream, outputStream, Thread.currentThread());
    }

    private boolean isActiveDirectoryAuthentication(Database object) {
        return ((String)(object = object.getConnection().getURL())).toLowerCase().contains("authentication=activedirectorypassword") || ((String)object).toLowerCase().contains("authentication=activedirectorymsi") || ((String)object).toLowerCase().contains("activedirectoryintegrated");
    }

    private String getDatabaseHostname(Database object) {
        object = object.getConnection().getURL();
        Object object2 = Pattern.compile(".*?//(.*?):(\\d+);.*").matcher((CharSequence)object);
        if (((Matcher)object2).matches()) {
            object = ((Matcher)object2).group(1);
            object2 = ((Matcher)object2).group(2);
        } else {
            object = object.replaceFirst(".*?//", "").replaceFirst(":.*", "").replaceFirst(";.*", "");
            object2 = "1433";
        }
        return "tcp:" + (String)object + "," + (String)object2;
    }

    private void loadSqlcmdProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner$ConfigFile.SQLCMD);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        this.addPropertiesToMdc();
        SqlcmdRunner sqlcmdRunner = this;
        sqlcmdRunner.handleSqlcmdExecutable(sqlcmdRunner.sqlcmdExec);
        SqlcmdRunner sqlcmdRunner2 = this;
        sqlcmdRunner2.handleTimeout(sqlcmdRunner2.timeout);
        this.logProperties();
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdArgs", string);
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim((String)string, (String)" ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdTimeout", String.valueOf(n2));
            NativeRunnerUtil.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a timeout of '" + n2 + "'");
        }
    }

    private void handleSqlcmdExecutable(File file) {
        if (file == null) {
            return;
        }
        this.checkSqlcmdExecutable(file);
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'sqlcmd' executable located at:  '" + file.getCanonicalPath() + "'");
            Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdPath", file.toString());
            this.sqlcmdExec = file;
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.keepTempFile = SqlcmdConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)SqlcmdConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        this.tempName = SqlcmdConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)SqlcmdConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = SqlcmdConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)SqlcmdConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.tempOverwrite = SqlcmdConfiguration.TEMP_OVERWRITE.getCurrentValue() != null ? (Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getCurrentValue() : this.tempOverwrite;
        this.logFile = SqlcmdConfiguration.LOG_FILE.getCurrentValue() != null ? (String)SqlcmdConfiguration.LOG_FILE.getCurrentValue() : this.logFile;
        this.catalogName = SqlcmdConfiguration.CATALOG_NAME.getCurrentValue() != null ? (String)SqlcmdConfiguration.CATALOG_NAME.getCurrentValue() : this.catalogName;
        Integer n2 = this.timeout = SqlcmdConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)SqlcmdConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        if (SqlcmdConfiguration.PATH.getCurrentValue() != null) {
            this.sqlcmdExec = new File((String)SqlcmdConfiguration.PATH.getCurrentValue());
        }
        if (SqlcmdConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)SqlcmdConfiguration.ARGS.getCurrentValue());
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a log file value of '" + this.logFile + "'");
        }
    }

    private void checkSqlcmdExecutable(File file) {
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable was not found at '" + file.getAbsolutePath() + "'.\nPlease check the liquibase.sqlcmd.path property in liquibase.sqlcmd.conf, the LIQUIBASE_SQLCMD_PATH Environment variable, \nor other config locations. Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sqlcmd-integration.html.\n");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable located at '" + file.getAbsolutePath() + "' cannot be executed");
        }
    }

    private void addPropertiesToMdc() {
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdKeepTemp", String.valueOf(this.keepTempFile));
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdKeepTempPath", this.tempPath);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdKeepTempName", this.tempName);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdLogFile", this.logFile);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdTempOverwrite", String.valueOf(this.tempOverwrite));
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdCatalogName", this.catalogName);
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.sqlcmd.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for timeoutString 'liquibase.sqlcmd.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sqlcmd-integration.html");
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, "liquibase.sqlcmd.keep.temp");
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = NativeRunnerUtil.getBooleanFromProperties(properties, SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("logFile"));
        }
        if (properties.containsKey("liquibase.sqlcmd.path")) {
            this.sqlcmdExec = new File(properties.getProperty("liquibase.sqlcmd.path"));
        }
        if (properties.containsKey("liquibase.sqlcmd.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.sqlcmd.args")) {
            this.handleArgs(properties.getProperty("liquibase.sqlcmd.args"));
        }
        if (properties.containsKey("liquibase.sqlcmd.catalogName")) {
            this.catalogName = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("catalogName"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSql(String string) {
        BufferedWriter bufferedWriter;
        block18: {
            Object object;
            if (this.sqlStrings == null) return;
            if (this.sqlStrings.length == 0) {
                return;
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Creating the SQL run script");
            Object object2 = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlcmdConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
            try {
                this.outFile = object2.generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
            object2 = this.sqlStrings;
            int n2 = this.sqlStrings.length;
            for (int i2 = 0; i2 < n2 && !this.warnOnOutStatements((Sql)(object = object2[i2])); ++i2) {
            }
            object2 = System.lineSeparator();
            bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            object = null;
            try {
                if (this.logFile != null) {
                    String string2;
                    try {
                        Scope.getCurrentScope().getLog(SqlPlusRunner.class).info("Using log file name '" + this.logFile + "'");
                        string2 = new NativeToolFileCreator(this.changeSet, this.logFile, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlcmdConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite")).generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.log, false).getAbsolutePath();
                    }
                    catch (IOException iOException) {
                        throw new UnexpectedLiquibaseException((Throwable)iOException);
                    }
                    bufferedWriter.write("\n:OUT \"" + string2 + "\"" + (String)object2);
                }
                if (string != null) {
                    bufferedWriter.write("USE [" + string + "];" + (String)object2);
                    bufferedWriter.write("GO".concat(String.valueOf(object2)));
                }
                bufferedWriter.write(";".concat(String.valueOf(object2)));
                this.writeSqlStrings(bufferedWriter);
                String string3 = this.getEndDelimiter();
                if (string3 != null && string3.equals("\n/$")) {
                    bufferedWriter.write("/\n");
                }
                bufferedWriter.write("GO\n");
                if (bufferedWriter == null) return;
                if (object == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (bufferedWriter == null) throw throwable3;
                    if (object == null) {
                        bufferedWriter.close();
                        throw throwable3;
                    }
                    try {
                        bufferedWriter.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ((Throwable)object).addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            try {
                bufferedWriter.close();
                return;
            }
            catch (Throwable throwable) {
                ((Throwable)object).addSuppressed(throwable);
                return;
            }
        }
        bufferedWriter.close();
    }

    private boolean warnOnOutStatements(Sql stringArray) {
        stringArray = stringArray.toSql().split("\n");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].matches("(?im)^\\s*:out .*")) continue;
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("OUT statements were detected in your script for changeset " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent SQLCMD output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    @Override
    public String getIntegrationDisplayName() {
        return "SQLCMD";
    }
}

