/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import java.io.InputStream;
import liquibase.Scope;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.FileUtil;

public class ResourceUtil {
    public static Resource getResource(String string) {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        if (ResourceUtil.isAbsolute(string) && (pathHandlerFactory = pathHandlerFactory.getResource(string)).exists()) {
            return pathHandlerFactory;
        }
        return Scope.getCurrentScope().getResourceAccessor().get(string);
    }

    public static boolean isAbsolute(String string) {
        if (string.matches("^\\w\\w+:.*")) {
            return true;
        }
        return FileUtil.isAbsolute((String)string);
    }

    public static InputStream getResourceInputStream(String string) {
        return ResourceUtil.getResourceInputStream(ResourceUtil.getResource(string));
    }

    public static InputStream getResourceInputStream(Resource resource) {
        if (resource.exists()) {
            return resource.openInputStream();
        }
        return null;
    }
}

