/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license.pro;

import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.license.LicenseInfo;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.Location;
import liquibase.license.pro.Base64Source;
import liquibase.license.pro.DaticalTrueLicenseService$1;
import liquibase.license.pro.LicenseTier;
import liquibase.license.pro.LicensingSchema;
import liquibase.logging.Logger;
import liquibase.pro.packaged.ra;
import liquibase.pro.packaged.ri;
import liquibase.pro.packaged.rm;
import liquibase.pro.packaged.rr;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class DaticalTrueLicenseService
implements LicenseService {
    private static final String INVALID_LICENSE_KEY_WARN = "WARNING! Invalid license key detected: Licensed Liquibase features disabled! Get a free trial license key at https://liquibase.com/trial and include liquibase.licenseKey in defaults file, or add via CLI or Environment variable. Learn more at https://docs.liquibase.com.";
    private static final String EXPIRED_LICENSE_KEY_WARN = "WARNING! Your Liquibase License has expired! Licensed Liquibase features will be disabled! Get a free trial license key at https://liquibase.com/trial";
    private static final String RENEW_MSG = "To renew " + LicenseTier.PRO.getSubject() + " or " + LicenseTier.LABS.getSubject() + " please contact sales@liquibase.com or go to https://www.liquibase.com/pricing";
    private static final String LIQUIBASE_LICENSED_MESSAGE = "%s %s by Liquibase licensed to %s until %s";
    private static final String LIQUIBASE_OPEN_SOURCE_MSG = "Liquibase Open Source %s by Liquibase";
    private Map<String, ri> managers = new HashMap<String, ri>();
    private static boolean hasLoggedLicenseFailure = false;
    private LicenseInstallResult installResult;
    private String buildVersion;
    private final List<LicenseTier> installedLicenses = new ArrayList<LicenseTier>(LicenseTier.values().length);
    private String knownInvalidLicense;
    private boolean knownExpiredLicense = false;

    public DaticalTrueLicenseService() {
        this.addManager(LicenseTier.PRO.getSubject());
        this.addManager(LicenseTier.LABS.getSubject());
        this.buildVersion = LiquibaseUtil.getBuildVersionInfo();
    }

    private void addManager(String string) {
        ri ri2 = LicensingSchema.manager(string);
        this.managers.put(string, ri2);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean licenseIsValid(String string) {
        if (string.equals(this.knownInvalidLicense)) {
            return false;
        }
        if (!this.licenseIsInstalled()) {
            return false;
        }
        Object object = Scope.getCurrentScope().getLog(this.getClass());
        LicenseTier licenseTier2 = LicenseTier.fromSubject(string);
        if (licenseTier2 == null) {
            object.severe(String.format("Unrecognized license subject: %s", string));
            return false;
        }
        try {
            ri ri2 = this.managers.get(string);
            if (ri2 == null) {
                object.severe("Could not create LicenseConsumerManager");
                return false;
            }
            ri2.h();
            return true;
        }
        catch (rm rm2) {
            if (licenseTier2.getSupersetLicenses() != null) {
                for (LicenseTier licenseTier2 : licenseTier2.getSupersetLicenses()) {
                    if (!this.licenseIsValid(licenseTier2.getSubject())) continue;
                    return true;
                }
            }
            if (!hasLoggedLicenseFailure) {
                hasLoggedLicenseFailure = true;
                object = String.format("License with subject '%s' is not valid. %s", string, rm2.getMessage());
                Scope.getCurrentScope().getLog(this.getClass()).severe((String)object);
                this.knownInvalidLicense = string;
            }
            return false;
        }
    }

    public String getLicenseInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.licenseIsInstalled()) {
            if (!this.licenseIsValid(LicenseTier.PRO.getSubject())) {
                if (this.knownExpiredLicense) {
                    stringBuilder.append(EXPIRED_LICENSE_KEY_WARN).append(StreamUtil.getLineSeparator()).append(RENEW_MSG).append(StreamUtil.getLineSeparator());
                } else if (this.installResult != null && this.installResult.messages != null && this.installResult.messages.size() > 0) {
                    stringBuilder.append(StringUtil.join((Collection)this.installResult.messages, (String)StreamUtil.getLineSeparator())).append(StreamUtil.getLineSeparator());
                }
            }
            stringBuilder.append(String.format(LIQUIBASE_OPEN_SOURCE_MSG, this.buildVersion));
        } else {
            if (this.knownExpiredLicense) {
                stringBuilder.append(EXPIRED_LICENSE_KEY_WARN).append(StreamUtil.getLineSeparator()).append(RENEW_MSG).append(StreamUtil.getLineSeparator());
                return stringBuilder.toString();
            }
            Object object = this.getRelevantManager();
            if (object != null) {
                try {
                    ra ra2 = object.e();
                    object = DaticalTrueLicenseService.getValByAttributeTypeFromIssuerDN(ra2.getHolder().getName(), "CN");
                    Date date = ra2.getNotAfter();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                    int n2 = this.daysTilExpiration();
                    if (this.licenseIsAboutToExpire() && n2 > 0) {
                        stringBuilder.append(String.format(LIQUIBASE_LICENSED_MESSAGE, ra2.getSubject(), this.buildVersion, object, simpleDateFormat.format(date))).append(StreamUtil.getLineSeparator()).append(String.format("WARNING!  Your license will expire in %d days!", n2)).append(StreamUtil.getLineSeparator()).append(RENEW_MSG);
                    } else {
                        stringBuilder.append(String.format(LIQUIBASE_LICENSED_MESSAGE, ra2.getSubject(), this.buildVersion, object, simpleDateFormat.format(date)));
                    }
                }
                catch (rm rm2) {}
            }
        }
        return stringBuilder.toString();
    }

    public LicenseInfo getLicenseInfoObject() {
        Object object;
        if (this.licenseIsInstalled() && (object = this.getRelevantManager()) != null) {
            try {
                object = object.e();
                String string = DaticalTrueLicenseService.getValByAttributeTypeFromIssuerDN(((ra)object).getHolder().getName(), "CN");
                object = ((ra)object).getNotAfter();
                return new LicenseInfo(string, (Date)object);
            }
            catch (rm rm2) {}
        }
        return null;
    }

    public boolean licenseIsInstalled() {
        boolean bl2;
        block8: {
            Logger logger;
            if (this.installedLicenses.isEmpty()) {
                logger = LiquibaseLabsConfiguration.getLicenseKey();
                if (logger == null || !logger.found()) {
                    return false;
                }
                this.installResult = this.installLicense(new Location(logger.getProvidedValue().describe(), (String)logger.getValue()));
            }
            logger = Scope.getCurrentScope().getLog(this.getClass());
            bl2 = false;
            Object object = this.getRelevantManager();
            if (object != null) {
                try {
                    if (this.knownExpiredLicense) {
                        return false;
                    }
                    object.h();
                    bl2 = true;
                }
                catch (rr rr2) {
                    object = rr2;
                    if (rr2.getMessage().contains("License validity period has expired")) {
                        this.knownExpiredLicense = true;
                    }
                    logger.severe(((rr)object).getMessage());
                    bl2 = true;
                }
                catch (rm rm2) {
                    if (hasLoggedLicenseFailure) break block8;
                    hasLoggedLicenseFailure = true;
                    LicenseTier licenseTier = this.getRelevantLicenseTier();
                    logger.severe(String.format("License with subject '%s' is not valid. %s", licenseTier == null ? null : licenseTier.getSubject(), rm2.getMessage()));
                }
            }
        }
        return bl2;
    }

    public void disable() {
        this.installedLicenses.clear();
    }

    public void reset() {
        this.installedLicenses.clear();
    }

    public LicenseInstallResult installLicense(Location ... locationArray) {
        LicenseInstallResult licenseInstallResult = new LicenseInstallResult(0);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(GlobalConfiguration.FILTER_LOG_MESSAGES.getKey(), Boolean.FALSE);
        try {
            Scope.child(hashMap, (Scope.ScopedRunner)new DaticalTrueLicenseService$1(this, locationArray, licenseInstallResult));
        }
        catch (Exception exception) {}
        return licenseInstallResult;
    }

    public boolean licenseIsAboutToExpire() {
        boolean bl2 = false;
        Object object = this.getRelevantManager();
        if (object != null) {
            try {
                object = object.e();
                Date date = DaticalTrueLicenseService.addDays(new Date(), 30);
                bl2 = ((ra)object).getNotAfter().before(date);
            }
            catch (rm rm2) {}
        }
        return bl2;
    }

    public int daysTilExpiration() {
        int n2 = Integer.MAX_VALUE;
        ri ri2 = this.getRelevantManager();
        if (ri2 != null) {
            try {
                int n3 = DaticalTrueLicenseService.daysDifference(ri2.e().getNotAfter());
                if (n3 < Integer.MAX_VALUE) {
                    n2 = n3;
                }
            }
            catch (rm rm2) {}
        }
        return n2;
    }

    public Date getExpirationDate() {
        ri ri2 = this.getRelevantManager();
        if (ri2 != null) {
            try {
                return ri2.e().getNotAfter();
            }
            catch (rm rm2) {}
        }
        return null;
    }

    private ri getRelevantManager() {
        LicenseTier licenseTier = this.getRelevantLicenseTier();
        if (licenseTier != null) {
            return this.managers.get(licenseTier.getSubject());
        }
        return null;
    }

    private LicenseTier getRelevantLicenseTier() {
        return this.installedLicenses.stream().max(Comparator.comparingInt(LicenseTier::getValue)).orElse(null);
    }

    private LicenseInstallResult installFromBase64String(Location location) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        for (String string : this.managers.keySet()) {
            try {
                ri ri2 = this.managers.get(string);
                ri2.a(new Base64Source(location.getValue()));
                ra ra2 = ri2.e();
                if (!ra2.getSubject().equals(string)) {
                    DaticalTrueLicenseService daticalTrueLicenseService = this;
                    if (daticalTrueLicenseService.anotherManagerCanProcess(daticalTrueLicenseService.managers, ra2)) {
                        ri2.i();
                        continue;
                    }
                }
                if (this.knownInvalidLicense != null) continue;
                logger.info("Successfully installed license from " + location + ".\n");
                this.installedLicenses.add(LicenseTier.fromSubject(string));
            }
            catch (rr rr2) {
                n2 = 1;
                if (rr2.getMessage().contains("License validity period has expired")) {
                    stringBuilder.append("WARNING! Your Liquibase License has expired! Licensed Liquibase features will be disabled! Get a free trial license key at https://liquibase.com/trial\n");
                    stringBuilder.append(RENEW_MSG);
                    logger.severe(rr2.getMessage());
                    break;
                }
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + rr2.getMessage() + "\n");
                break;
            }
            catch (Exception exception) {
                n2 = 1;
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
        }
        return new LicenseInstallResult(n2, stringBuilder.toString());
    }

    private boolean anotherManagerCanProcess(Map<String, ri> map, ra ra2) {
        return map.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).equals(ra2.getSubject()));
    }

    private static Date addDays(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime();
    }

    private static int daysDifference(Date comparable) {
        LocalDate localDate = LocalDate.now();
        comparable = LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(comparable.getTime()));
        return (int)ChronoUnit.DAYS.between(localDate, (Temporal)((Object)comparable));
    }

    private static String getValByAttributeTypeFromIssuerDN(String stringArray, String string) {
        for (String string2 : stringArray.split(",")) {
            String[] stringArray2;
            if (!string2.contains(string) || (stringArray2 = string2.trim().split("="))[1] == null) continue;
            return stringArray2[1].trim();
        }
        return "";
    }

    static /* synthetic */ LicenseInstallResult access$000(DaticalTrueLicenseService daticalTrueLicenseService, Location location) {
        return daticalTrueLicenseService.installFromBase64String(location);
    }
}

