/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;

public class MySQLGroupConcat
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList expressionList;
    private boolean distinct = false;
    private List<OrderByElement> orderByElements;
    private String separator;

    public ExpressionList<?> getExpressionList() {
        return this.expressionList;
    }

    public void setExpressionList(ExpressionList expressionList) {
        this.expressionList = expressionList;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl2) {
        this.distinct = bl2;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GROUP_CONCAT(");
        if (this.isDistinct()) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append(this.expressionList);
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            stringBuilder.append(" ORDER BY ");
            for (int i2 = 0; i2 < this.orderByElements.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.orderByElements.get(i2).toString());
            }
        }
        if (this.separator != null) {
            stringBuilder.append(" SEPARATOR ").append(this.separator);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public MySQLGroupConcat withExpressionList(ExpressionList expressionList) {
        this.setExpressionList(expressionList);
        return this;
    }

    public MySQLGroupConcat withDistinct(boolean bl2) {
        this.setDistinct(bl2);
        return this;
    }

    public MySQLGroupConcat withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public MySQLGroupConcat withSeparator(String string) {
        this.setSeparator(string);
        return this;
    }

    public MySQLGroupConcat addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public MySQLGroupConcat addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }
}

