/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.update;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class UpdateSet
implements Serializable {
    protected ExpressionList<Column> columns = new ExpressionList((Expression[])new Column[0]);
    protected ExpressionList<Expression> values = new ExpressionList(new Expression[0]);

    public UpdateSet() {
    }

    public UpdateSet(Column column) {
        this.columns.add(column);
    }

    public UpdateSet(Column column, Expression expression) {
        this.columns.add(column);
        this.values.add(expression);
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public Column getColumn(int n2) {
        return (Column)this.columns.get(n2);
    }

    public void setColumns(ExpressionList<Column> expressionList) {
        this.columns = Objects.requireNonNull(expressionList);
    }

    public ExpressionList<?> getValues() {
        return this.values;
    }

    public Expression getValue(int n2) {
        return (Expression)this.values.get(n2);
    }

    public void setValues(ExpressionList expressionList) {
        this.values = Objects.requireNonNull(expressionList);
    }

    public void add(Column column, Expression expression) {
        this.add(column);
        this.add(expression);
    }

    public void add(Column column) {
        if (this.columns.size() < 2 && !(this.columns instanceof ParenthesedExpressionList)) {
            this.columns = new ParenthesedExpressionList<Column>(this.columns);
        }
        this.columns.add(column);
    }

    public void add(Expression expression) {
        if (this.values.size() < 2 && !(this.values instanceof ParenthesedExpressionList)) {
            this.values = new ParenthesedExpressionList<Expression>(this.values);
        }
        this.values.add(expression);
    }

    public void add(ExpressionList<?> expressionList) {
        this.values.addAll(expressionList);
    }

    public static final StringBuilder appendUpdateSetsTo(StringBuilder stringBuilder, Collection<UpdateSet> object) {
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            ((UpdateSet)object.next()).appendTo(stringBuilder, n2);
            ++n2;
        }
        return stringBuilder;
    }

    StringBuilder appendTo(StringBuilder stringBuilder, int n2) {
        if (n2 > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(Select.getStringList(this.columns, true, this.columns instanceof ParenthesedExpressionList));
        stringBuilder.append(" = ");
        stringBuilder.append(Select.getStringList(this.values, true, this.values instanceof ParenthesedExpressionList));
        return stringBuilder;
    }
}

