/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util;

import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;

public final class SelectUtils {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";

    private SelectUtils() {
    }

    public static Select buildSelectFromTableAndExpressions(Table table, Expression ... expressionArray) {
        SelectItem[] selectItemArray = new SelectItem[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            selectItemArray[i2] = new SelectItem<Expression>(expressionArray[i2]);
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, selectItemArray);
    }

    public static Select buildSelectFromTableAndExpressions(Table table, String ... stringArray) {
        SelectItem[] selectItemArray = new SelectItem[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            selectItemArray[i2] = new SelectItem<Expression>(CCJSqlParserUtil.parseExpression(stringArray[i2]));
        }
        return SelectUtils.buildSelectFromTableAndSelectItems(table, selectItemArray);
    }

    public static Select buildSelectFromTableAndSelectItems(Table table, SelectItem ... selectItemArray) {
        return new PlainSelect().addSelectItems(selectItemArray).withFromItem(table);
    }

    public static Select buildSelectFromTable(Table table) {
        return SelectUtils.buildSelectFromTableAndSelectItems(table, SelectItem.from(new AllColumns()));
    }

    public static void addExpression(Select select, Expression expression) {
        if (select instanceof PlainSelect) {
            ((PlainSelect)select).addSelectItem(expression);
            return;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static Join addJoin(Select select, Table aSTNodeAccessImpl, Expression expression) {
        if (select instanceof PlainSelect) {
            aSTNodeAccessImpl = new Join().withRightItem((FromItem)((Object)aSTNodeAccessImpl)).addOnExpression(expression);
            ((PlainSelect)select).addJoins(new Join[]{aSTNodeAccessImpl});
            return aSTNodeAccessImpl;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    public static void addGroupBy(Select select, Expression expression) {
        if (select instanceof PlainSelect) {
            ((PlainSelect)select).addGroupByColumnReference(expression);
            return;
        }
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }
}

