/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class LimitDeparser
extends AbstractDeParser<Limit> {
    private ExpressionVisitor expressionVisitor;

    public LimitDeparser(ExpressionVisitor expressionVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Limit limit) {
        this.buffer.append(" LIMIT ");
        if (limit.isLimitNull()) {
            this.buffer.append("NULL");
        } else if (limit.isLimitAll()) {
            this.buffer.append("ALL");
        } else {
            if (null != limit.getOffset()) {
                limit.getOffset().accept(this.expressionVisitor);
                this.buffer.append(", ");
            }
            if (null != limit.getRowCount()) {
                limit.getRowCount().accept(this.expressionVisitor);
            }
        }
        if (limit.getByExpressions() != null) {
            this.buffer.append(" BY ");
            limit.getByExpressions().accept(this.expressionVisitor);
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

