/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowDefinition;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralSubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralView;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OptimizeFor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotXml;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.TableFunction;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Values;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.GroupByDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.LimitDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.OrderByDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ValuesStatementDeParser;

public class SelectDeParser
extends AbstractDeParser<PlainSelect>
implements FromItemVisitor,
PivotVisitor,
SelectItemVisitor,
SelectVisitor {
    private ExpressionVisitor expressionVisitor;

    public SelectDeParser() {
        this(new StringBuilder());
    }

    public SelectDeParser(StringBuilder stringBuilder) {
        this(new ExpressionVisitorAdapter(), stringBuilder);
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void visit(ParenthesedSelect parenthesedSelect) {
        List<WithItem> list = parenthesedSelect.getWithItemsList();
        if (list != null && !list.isEmpty()) {
            this.buffer.append("WITH ");
            list = list.iterator();
            while (list.hasNext()) {
                ((WithItem)list.next()).accept(this);
                this.buffer.append(" ");
            }
        }
        this.buffer.append("(");
        parenthesedSelect.getSelect().accept(this);
        this.buffer.append(")");
        if (parenthesedSelect.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(parenthesedSelect.isOracleSiblings(), parenthesedSelect.getOrderByElements());
        }
        if ((list = parenthesedSelect.getAlias()) != null) {
            this.buffer.append(list);
        }
        if ((list = parenthesedSelect.getPivot()) != null) {
            ((Pivot)((Object)list)).accept(this);
        }
        if ((list = parenthesedSelect.getUnPivot()) != null) {
            ((UnPivot)((Object)list)).accept(this);
        }
        if (parenthesedSelect.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(parenthesedSelect.getLimit());
        }
        if (parenthesedSelect.getOffset() != null) {
            this.visit(parenthesedSelect.getOffset());
        }
        if (parenthesedSelect.getFetch() != null) {
            this.visit(parenthesedSelect.getFetch());
        }
        if (parenthesedSelect.getIsolation() != null) {
            this.buffer.append(parenthesedSelect.getIsolation().toString());
        }
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        List<SelectItem<?>> object2;
        List<WithItem> list = plainSelect.getWithItemsList();
        if (list != null && !list.isEmpty()) {
            this.buffer.append("WITH ");
            list = list.iterator();
            while (list.hasNext()) {
                ((WithItem)list.next()).accept(this);
                if (list.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("SELECT ");
        if (plainSelect.getMySqlHintStraightJoin()) {
            this.buffer.append("STRAIGHT_JOIN ");
        }
        if ((list = plainSelect.getOracleHint()) != null) {
            this.buffer.append(list).append(" ");
        }
        if ((list = plainSelect.getSkip()) != null) {
            this.buffer.append(list).append(" ");
        }
        if ((list = plainSelect.getFirst()) != null) {
            this.buffer.append(list).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            if (plainSelect.getDistinct().isUseUnique()) {
                this.buffer.append("UNIQUE ");
            } else {
                this.buffer.append("DISTINCT ");
            }
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                list = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (list.hasNext()) {
                    list.next().accept(this);
                    if (!list.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        if ((list = plainSelect.getTop()) != null) {
            this.buffer.append(list).append(" ");
        }
        if (plainSelect.getMySqlSqlCacheFlag() != null) {
            this.buffer.append(plainSelect.getMySqlSqlCacheFlag().name()).append(" ");
        }
        if (plainSelect.getMySqlSqlCalcFoundRows()) {
            this.buffer.append("SQL_CALC_FOUND_ROWS ");
        }
        if ((object2 = plainSelect.getSelectItems()) != null) {
            list = object2.iterator();
            while (list.hasNext()) {
                list.next().accept(this);
                if (!list.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getIntoTables() != null) {
            this.buffer.append(" INTO ");
            list = plainSelect.getIntoTables().iterator();
            while (list.hasNext()) {
                this.visit((Table)list.next());
                if (!list.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getFromItem() != null) {
            this.buffer.append(" FROM ");
            plainSelect.getFromItem().accept(this);
            if (plainSelect.getFromItem() instanceof Table && ((Table)((Object)(list = (Table)plainSelect.getFromItem()))).getSampleClause() != null) {
                ((Table)((Object)list)).getSampleClause().appendTo(this.buffer);
            }
        }
        if (plainSelect.getLateralViews() != null) {
            for (LateralView lateralView : plainSelect.getLateralViews()) {
                this.deparseLateralView(lateralView);
            }
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if (plainSelect.isUsingFinal()) {
            this.buffer.append(" FINAL");
        }
        if (plainSelect.getKsqlWindow() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getKsqlWindow().toString());
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupBy() != null) {
            this.buffer.append(" ");
            new GroupByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.getGroupBy());
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getQualify() != null) {
            this.buffer.append(" QUALIFY ");
            plainSelect.getQualify().accept(this.expressionVisitor);
        }
        if (plainSelect.getWindowDefinitions() != null) {
            this.buffer.append(" WINDOW ");
            this.buffer.append(plainSelect.getWindowDefinitions().stream().map(WindowDefinition::toString).collect(Collectors.joining(", ")));
        }
        if (plainSelect.isForUpdate()) {
            this.buffer.append(" FOR UPDATE");
            if (plainSelect.getForUpdateTable() != null) {
                this.buffer.append(" OF ").append(plainSelect.getForUpdateTable());
            }
            if (plainSelect.getWait() != null) {
                this.buffer.append(plainSelect.getWait());
            }
            if (plainSelect.isNoWait()) {
                this.buffer.append(" NOWAIT");
            } else if (plainSelect.isSkipLocked()) {
                this.buffer.append(" SKIP LOCKED");
            }
        }
        if (plainSelect.getForClause() != null) {
            plainSelect.getForClause().appendTo(this.buffer);
        }
        if (plainSelect.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.isEmitChanges()) {
            this.buffer.append(" EMIT CHANGES");
        }
        if (plainSelect.getLimitBy() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(plainSelect.getLimitBy());
        }
        if (plainSelect.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.visit(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.visit(plainSelect.getFetch());
        }
        if (plainSelect.getIsolation() != null) {
            this.buffer.append(plainSelect.getIsolation().toString());
        }
        if (plainSelect.getOptimizeFor() != null) {
            this.deparseOptimizeFor(plainSelect.getOptimizeFor());
        }
        if (plainSelect.getForXmlPath() != null) {
            this.buffer.append(" FOR XML PATH(").append(plainSelect.getForXmlPath()).append(")");
        }
    }

    @Override
    public void visit(SelectItem selectItem) {
        selectItem.getExpression().accept(this.expressionVisitor);
        if (selectItem.getAlias() != null) {
            this.buffer.append(selectItem.getAlias().toString());
        }
    }

    @Override
    public void visit(Table serializable) {
        this.buffer.append(serializable.getFullyQualifiedName());
        Serializable serializable2 = serializable.getAlias();
        if (serializable2 != null) {
            this.buffer.append(serializable2);
        }
        if ((serializable2 = serializable.getPivot()) != null) {
            ((Pivot)serializable2).accept(this);
        }
        if ((serializable2 = serializable.getUnPivot()) != null) {
            ((UnPivot)serializable2).accept(this);
        }
        if ((serializable2 = serializable.getIndexHint()) != null) {
            this.buffer.append(serializable2);
        }
        if ((serializable = serializable.getSqlServerHints()) != null) {
            this.buffer.append(serializable);
        }
    }

    @Override
    public void visit(Pivot pivot) {
        this.buffer.append(" PIVOT (").append(PlainSelect.getStringList(pivot.getFunctionItems()));
        this.buffer.append(" FOR ");
        pivot.getForColumns().accept(this.expressionVisitor);
        this.buffer.append(" IN ").append(PlainSelect.getStringList(pivot.getInItems(), true, true));
        this.buffer.append(")");
        if (pivot.getAlias() != null) {
            this.buffer.append(pivot.getAlias().toString());
        }
    }

    @Override
    public void visit(UnPivot unPivot) {
        boolean bl2 = unPivot.getIncludeNullsSpecified();
        boolean bl3 = unPivot.getIncludeNulls();
        List<Column> list = unPivot.getUnPivotClause();
        List<Column> list2 = unPivot.getUnPivotForClause();
        this.buffer.append(" UNPIVOT").append(bl2 && bl3 ? " INCLUDE NULLS" : "").append(bl2 && !bl3 ? " EXCLUDE NULLS" : "").append(" (").append(PlainSelect.getStringList(list, true, list != null && list.size() > 1)).append(" FOR ").append(PlainSelect.getStringList(list2, true, list2 != null && list2.size() > 1)).append(" IN ").append(PlainSelect.getStringList(unPivot.getUnPivotInClause(), true, true)).append(")");
        if (unPivot.getAlias() != null) {
            this.buffer.append(unPivot.getAlias().toString());
        }
    }

    @Override
    public void visit(PivotXml pivotXml) {
        ExpressionList<Column> expressionList = pivotXml.getForColumns();
        this.buffer.append(" PIVOT XML (").append(PlainSelect.getStringList(pivotXml.getFunctionItems())).append(" FOR ").append(PlainSelect.getStringList(expressionList, true, expressionList != null && expressionList.size() > 1)).append(" IN (");
        if (pivotXml.isInAny()) {
            this.buffer.append("ANY");
        } else if (pivotXml.getInSelect() != null) {
            this.buffer.append(pivotXml.getInSelect());
        } else {
            this.buffer.append(PlainSelect.getStringList(pivotXml.getInItems()));
        }
        this.buffer.append("))");
    }

    public void visit(Offset offset) {
        this.buffer.append(" OFFSET ");
        offset.getOffset().accept(this.expressionVisitor);
        if (offset.getOffsetParam() != null) {
            this.buffer.append(" ").append(offset.getOffsetParam());
        }
    }

    public void visit(Fetch fetch) {
        this.buffer.append(" FETCH ");
        if (fetch.isFetchParamFirst()) {
            this.buffer.append("FIRST ");
        } else {
            this.buffer.append("NEXT ");
        }
        fetch.getExpression().accept(this.expressionVisitor);
        this.buffer.append(" ").append(fetch.getFetchParam()).append(" ONLY");
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void deparseJoin(Join join) {
        if (join.isGlobal()) {
            this.buffer.append(" GLOBAL ");
        }
        if (join.isSimple() && join.isOuter()) {
            this.buffer.append(", OUTER ");
        } else if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isNatural()) {
                this.buffer.append(" NATURAL");
            }
            if (join.isRight()) {
                this.buffer.append(" RIGHT");
            } else if (join.isFull()) {
                this.buffer.append(" FULL");
            } else if (join.isLeft()) {
                this.buffer.append(" LEFT");
            } else if (join.isCross()) {
                this.buffer.append(" CROSS");
            }
            if (join.isOuter()) {
                this.buffer.append(" OUTER");
            } else if (join.isInner()) {
                this.buffer.append(" INNER");
            } else if (join.isSemi()) {
                this.buffer.append(" SEMI");
            }
            if (join.isStraight()) {
                this.buffer.append(" STRAIGHT_JOIN ");
            } else if (join.isApply()) {
                this.buffer.append(" APPLY ");
            } else {
                this.buffer.append(" JOIN ");
            }
        }
        join.getFromItem().accept(this);
        if (join.isWindowJoin()) {
            this.buffer.append(" WITHIN ");
            this.buffer.append(join.getJoinWindow().toString());
        }
        for (Expression expression : join.getOnExpressions()) {
            this.buffer.append(" ON ");
            expression.accept(this.expressionVisitor);
        }
        if (join.getUsingColumns().size() > 0) {
            this.buffer.append(" USING (");
            Iterator<Expression> iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Expression expression;
                expression = (Column)iterator.next();
                this.buffer.append(((Column)expression).toString());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    public void deparseLateralView(LateralView lateralView) {
        this.buffer.append(" LATERAL VIEW");
        if (lateralView.isUsingOuter()) {
            this.buffer.append(" OUTER");
        }
        this.buffer.append(" ");
        lateralView.getGeneratorFunction().accept(this.expressionVisitor);
        if (lateralView.getTableAlias() != null) {
            this.buffer.append(" ").append(lateralView.getTableAlias());
        }
        this.buffer.append(" ").append(lateralView.getColumnAlias());
    }

    @Override
    public void visit(SetOperationList setOperationList) {
        List<WithItem> list = setOperationList.getWithItemsList();
        if (list != null && !list.isEmpty()) {
            this.buffer.append("WITH ");
            list = list.iterator();
            while (list.hasNext()) {
                ((WithItem)list.next()).accept(this);
                if (list.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        for (int i2 = 0; i2 < setOperationList.getSelects().size(); ++i2) {
            if (i2 != 0) {
                this.buffer.append(' ').append(setOperationList.getOperations().get(i2 - 1)).append(' ');
            }
            setOperationList.getSelects().get(i2).accept(this);
        }
        if (setOperationList.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(setOperationList.getOrderByElements());
        }
        if (setOperationList.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(setOperationList.getLimit());
        }
        if (setOperationList.getOffset() != null) {
            this.visit(setOperationList.getOffset());
        }
        if (setOperationList.getFetch() != null) {
            this.visit(setOperationList.getFetch());
        }
        if (setOperationList.getIsolation() != null) {
            this.buffer.append(setOperationList.getIsolation().toString());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        if (withItem.isRecursive()) {
            this.buffer.append("RECURSIVE ");
        }
        this.buffer.append(withItem.getAlias().getName());
        if (withItem.getWithItemList() != null) {
            this.buffer.append(" ").append(PlainSelect.getStringList(withItem.getWithItemList(), true, true));
        }
        this.buffer.append(" AS ");
        withItem.getSelect().accept(this);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.buffer.append(lateralSubSelect.getPrefix());
        this.visit((ParenthesedSelect)lateralSubSelect);
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.buffer.append(tableFunction.toString());
    }

    @Override
    public void visit(ParenthesedFromItem parenthesedFromItem) {
        this.buffer.append("(");
        parenthesedFromItem.getFromItem().accept(this);
        Object object = parenthesedFromItem.getJoins();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Join join = (Join)object.next();
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        this.buffer.append(")");
        if (parenthesedFromItem.getAlias() != null) {
            this.buffer.append(parenthesedFromItem.getAlias().toString());
        }
        if (parenthesedFromItem.getPivot() != null) {
            this.visit(parenthesedFromItem.getPivot());
        }
        if (parenthesedFromItem.getUnPivot() != null) {
            this.visit(parenthesedFromItem.getUnPivot());
        }
    }

    @Override
    public void visit(Values values) {
        new ValuesStatementDeParser(this.expressionVisitor, this.buffer).deParse(values);
    }

    private void deparseOptimizeFor(OptimizeFor optimizeFor) {
        this.buffer.append(" OPTIMIZE FOR ");
        this.buffer.append(optimizeFor.getRowCount());
        this.buffer.append(" ROWS");
    }

    @Override
    void deParse(PlainSelect plainSelect) {
        plainSelect.accept(this);
    }
}

