/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.statement.Block;
import liquibase.repackaged.net.sf.jsqlparser.statement.Commit;
import liquibase.repackaged.net.sf.jsqlparser.statement.CreateFunctionalStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DeclareStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.DescribeStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ExplainStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ExplainStatement$Option;
import liquibase.repackaged.net.sf.jsqlparser.statement.IfElseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.PurgeStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ResetStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.RollbackStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.SavepointStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.SetStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ShowColumnsStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.ShowStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.statement.UnsupportedStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.UseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSession;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.analyze.Analyze;
import liquibase.repackaged.net.sf.jsqlparser.statement.comment.Comment;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.index.CreateIndex;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.schema.CreateSchema;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.AlterView;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.view.CreateView;
import liquibase.repackaged.net.sf.jsqlparser.statement.delete.Delete;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.repackaged.net.sf.jsqlparser.statement.execute.Execute;
import liquibase.repackaged.net.sf.jsqlparser.statement.grant.Grant;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.Insert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.Merge;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeInsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeUpdate;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.show.ShowIndexStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.show.ShowTablesStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.truncate.Truncate;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.Update;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterSequenceDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterSessionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateSequenceDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateSynonymDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.DeclareStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.DeleteDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.DropDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.GrantDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.InsertDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ResetStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SelectDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowColumnsStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowIndexStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ShowTablesStatementDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.UpdateDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.UpsertDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.UseStatementDeParser;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(StringBuilder stringBuilder) {
        this(new ExpressionDeParser(), new SelectDeParser(), stringBuilder);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.selectDeParser.setBuffer(stringBuilder);
        this.selectDeParser.setExpressionVisitor(expressionDeParser);
        this.expressionDeParser.setSelectVisitor(selectDeParser);
        this.expressionDeParser.setBuffer(stringBuilder);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        new CreateIndexDeParser(this.buffer).deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        StatementDeParser statementDeParser = this;
        new CreateTableDeParser(statementDeParser, statementDeParser.buffer).deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        new CreateViewDeParser(this.buffer).deParse(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        new AlterViewDeParser(this.buffer).deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        new DeleteDeParser(this.expressionDeParser, this.buffer).deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        new DropDeParser(this.buffer).deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer).deParse(insert);
    }

    @Override
    public void visit(Select select) {
        select.accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
        this.buffer.append("TRUNCATE");
        if (truncate.isTableToken()) {
            this.buffer.append(" TABLE");
        }
        if (truncate.isOnly()) {
            this.buffer.append(" ONLY");
        }
        this.buffer.append(" ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
    }

    @Override
    public void visit(Update update) {
        new UpdateDeParser(this.expressionDeParser, this.buffer).deParse(update);
    }

    @Override
    public void visit(Analyze analyze) {
        this.buffer.append("ANALYZE ");
        this.buffer.append(analyze.getTable());
    }

    @Override
    public void visit(Alter alter) {
        new AlterDeParser(this.buffer).deParse(alter);
    }

    @Override
    public void visit(Statements statements) {
        statements.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        new ExecuteDeParser(this.expressionDeParser, this.buffer).deParse(execute);
    }

    @Override
    public void visit(SetStatement setStatement) {
        new SetStatementDeParser(this.expressionDeParser, this.buffer).deParse(setStatement);
    }

    @Override
    public void visit(ResetStatement resetStatement) {
        new ResetStatementDeParser(this.expressionDeParser, this.buffer).deParse(resetStatement);
    }

    @Override
    public void visit(Merge merge) {
        List<WithItem> list = merge.getWithItemsList();
        if (list != null && !list.isEmpty()) {
            this.buffer.append("WITH ");
            list = list.iterator();
            while (list.hasNext()) {
                ((WithItem)list.next()).accept(this.expressionDeParser);
                if (list.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("MERGE INTO ");
        merge.getTable().accept(this.selectDeParser);
        this.buffer.append(" USING ");
        merge.getFromItem().accept(this.selectDeParser);
        this.buffer.append(" ON (");
        merge.getOnCondition().accept(this.expressionDeParser);
        this.buffer.append(")");
        list = merge.getMergeInsert();
        MergeUpdate mergeUpdate = merge.getMergeUpdate();
        if (merge.isInsertFirst() && list != null) {
            this.deparseMergeInsert((MergeInsert)((Object)list));
        }
        if (mergeUpdate != null) {
            this.buffer.append(" WHEN MATCHED THEN UPDATE SET ");
            StatementDeParser.deparseUpdateSets(mergeUpdate.getUpdateSets(), this.buffer, this.expressionDeParser);
            if (mergeUpdate.getWhereCondition() != null) {
                this.buffer.append(" WHERE ");
                mergeUpdate.getWhereCondition().accept(this.expressionDeParser);
            }
            if (mergeUpdate.getDeleteWhereCondition() != null) {
                this.buffer.append(" DELETE WHERE ");
                mergeUpdate.getDeleteWhereCondition().accept(this.expressionDeParser);
            }
        }
        if (!merge.isInsertFirst() && list != null) {
            this.deparseMergeInsert((MergeInsert)((Object)list));
        }
    }

    private void deparseMergeInsert(MergeInsert mergeInsert) {
        this.buffer.append(" WHEN NOT MATCHED THEN INSERT ");
        if (mergeInsert.getColumns() != null) {
            mergeInsert.getColumns().accept(this.expressionDeParser);
        }
        this.buffer.append(" VALUES ");
        mergeInsert.getValues().accept(this.expressionDeParser);
        if (mergeInsert.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeInsert.getWhereCondition().accept(this.expressionDeParser);
        }
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
        this.buffer.append(savepointStatement.toString());
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
        this.buffer.append(rollbackStatement.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer).deParse(upsert);
    }

    @Override
    public void visit(UseStatement useStatement) {
        new UseStatementDeParser(this.buffer).deParse(useStatement);
    }

    @Override
    public void visit(ShowColumnsStatement showColumnsStatement) {
        new ShowColumnsStatementDeParser(this.buffer).deParse(showColumnsStatement);
    }

    @Override
    public void visit(ShowIndexStatement showIndexStatement) {
        new ShowIndexStatementDeParser(this.buffer).deParse(showIndexStatement);
    }

    @Override
    public void visit(ShowTablesStatement showTablesStatement) {
        new ShowTablesStatementDeparser(this.buffer).deParse(showTablesStatement);
    }

    @Override
    public void visit(Block block) {
        this.buffer.append("BEGIN\n");
        if (block.getStatements() != null) {
            Iterator<Statement> iterator = block.getStatements().getStatements().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
        if (block.hasSemicolonAfterEnd()) {
            this.buffer.append(";");
        }
    }

    @Override
    public void visit(Comment comment) {
        this.buffer.append(comment.toString());
    }

    @Override
    public void visit(DescribeStatement describeStatement) {
        this.buffer.append("DESCRIBE ");
        this.buffer.append(describeStatement.getTable());
    }

    @Override
    public void visit(ExplainStatement explainStatement) {
        this.buffer.append("EXPLAIN ");
        if (explainStatement.getOptions() != null) {
            this.buffer.append(explainStatement.getOptions().values().stream().map(ExplainStatement$Option::formatOption).collect(Collectors.joining(" ")));
            this.buffer.append(" ");
        }
        explainStatement.getStatement().accept(this);
    }

    @Override
    public void visit(ShowStatement showStatement) {
        new ShowStatementDeParser(this.buffer).deParse(showStatement);
    }

    @Override
    public void visit(DeclareStatement declareStatement) {
        new DeclareStatementDeParser(this.expressionDeParser, this.buffer).deParse(declareStatement);
    }

    @Override
    public void visit(Grant grant) {
        new GrantDeParser(this.buffer).deParse(grant);
    }

    @Override
    public void visit(CreateSchema createSchema) {
        this.buffer.append(createSchema.toString());
    }

    @Override
    public void visit(CreateSequence createSequence) {
        new CreateSequenceDeParser(this.buffer).deParse(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        new AlterSequenceDeParser(this.buffer).deParse(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.buffer.append(createFunctionalStatement.toString());
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        new CreateSynonymDeparser(this.buffer).deParse(createSynonym);
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(AlterSession alterSession) {
        new AlterSessionDeParser(this.buffer).deParse(alterSession);
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
        renameTableStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
        purgeStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
        alterSystemStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(UnsupportedStatement unsupportedStatement) {
        unsupportedStatement.appendTo(this.buffer);
    }
}

