/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SqlNotAllowedToContainRevoke
extends AbstractNotAllowedToContainRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("revoke\\s"), Pattern.compile("revoke\\["));
    }

    @Override
    public String getFailureMessage() {
        return "A statement revoking privileges from a role or user was detected in your changelog. Revoking privileges can lead to issues with data access and the proper function of database objects and applications that depend on the role or user.  We recommend this changeset be carefully reviewed.";
    }

    @Override
    public String getName() {
        return "Warn on Detection of 'REVOKE' Statements";
    }

    @Override
    public String getDescription() {
        return "This check warns a user when SQL contains 'REVOKE' statements so that they can ensure that the privilege being revoked won't lead to data access and dependency issues.";
    }

    @Override
    public String getShortName() {
        return "SqlRevokeWarn";
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.UNMODELED;
    }
}

