/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.expression.AllValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnalyticExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnyComparisonExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ArrayConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ArrayExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.BinaryExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CaseExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CastExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.CollateExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ConnectByRootOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.DateValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.DoubleValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExtractExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.Function;
import liquibase.repackaged.net.sf.jsqlparser.expression.HexValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.IntervalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcNamedParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.KeepExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.LongValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLGroupConcat;
import liquibase.repackaged.net.sf.jsqlparser.expression.NextValExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.NotExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.NullValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.NumericBind;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleNamedFunctionParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.OverlapsCondition;
import liquibase.repackaged.net.sf.jsqlparser.expression.Parenthesis;
import liquibase.repackaged.net.sf.jsqlparser.expression.RangeExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowConstructor;
import liquibase.repackaged.net.sf.jsqlparser.expression.RowGetExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.SignedExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.StringValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimeKeyExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimeValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimestampValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.TimezoneExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.TranscodingFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.TrimFunction;
import liquibase.repackaged.net.sf.jsqlparser.expression.UserVariable;
import liquibase.repackaged.net.sf.jsqlparser.expression.VariableAssignment;
import liquibase.repackaged.net.sf.jsqlparser.expression.WhenClause;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowElement;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowOffset;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowRange;
import liquibase.repackaged.net.sf.jsqlparser.expression.XMLSerializeExpr;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Division;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.IntegerDivision;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.conditional.XorExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.Between;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.FullTextSearch;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GeometryDistance;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.InExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsBooleanExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsDistinctExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.Matches;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MemberOfExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MinorThan;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllTableColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class ExpressionValidator
extends AbstractValidator<Expression>
implements ExpressionVisitor {
    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, andExpression.isUseOperator() ? " && " : " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        between.getBetweenExpressionStart().accept(this);
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(OverlapsCondition overlapsCondition) {
        this.validateOptionalExpressionList(overlapsCondition.getLeft());
        this.validateOptionalExpressionList(overlapsCondition.getRight());
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(IntegerDivision division) {
        this.visitBinaryExpression(division, " DIV ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
    }

    @Override
    public void visit(HexValue hexValue) {
    }

    @Override
    public void visit(NotExpression notExpr) {
        notExpr.getExpression().accept(this);
    }

    @Override
    public void visit(BitwiseRightShift expr) {
        this.visitBinaryExpression(expr, " >> ");
    }

    @Override
    public void visit(BitwiseLeftShift expr) {
        this.visitBinaryExpression(expr, " << ");
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalExpression(expression.getLeftExpression(), this);
            if (expression.getOldOracleJoinSyntax() != 0) {
                this.validateFeature(c, Feature.oracleOldJoinSyntax);
            }
            this.validateOptionalExpression(expression.getRightExpression(), this);
            if (expression.getOraclePriorPosition() == 0) continue;
            this.validateFeature(c, Feature.oraclePriorPosition);
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalExpression(inExpression.getLeftExpression(), this);
            if (inExpression.getOldOracleJoinSyntax() == 0) continue;
            this.validateFeature(c, Feature.oracleOldJoinSyntax);
        }
        this.validateOptionalExpression(inExpression.getRightExpression(), this);
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        this.validateOptionalExpressions(fullTextSearch.getMatchColumns());
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        isBooleanExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.validateFeature(Feature.jdbcParameter);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.validateFeature(Feature.exprLike);
        this.visitBinaryExpression(likeExpression, (likeExpression.isNot() ? " NOT" : "") + (likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE "));
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(MemberOfExpression memberOfExpression) {
        memberOfExpression.getLeftExpression().accept(this);
        memberOfExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(NullValue nullValue) {
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(XorExpression xorExpression) {
        this.visitBinaryExpression(xorExpression, " XOR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept(this);
    }

    @Override
    public void visit(StringValue stringValue) {
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    protected void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        binaryExpression.getLeftExpression().accept(this);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(ParenthesedSelect selectBody) {
        this.validateOptionalFromItem(selectBody);
    }

    @Override
    public void visit(Column tableColumn) {
        this.validateName(NamedObject.column, tableColumn.getFullyQualifiedName());
    }

    @Override
    public void visit(Function function) {
        this.validateFeature(Feature.function);
        this.validateOptionalExpressionList(function.getNamedParameters());
        this.validateOptionalExpressionList(function.getParameters());
        Object attribute = function.getAttribute();
        if (attribute instanceof Expression) {
            this.validateOptionalExpression((Expression)attribute, this);
        }
        this.validateOptionalExpression(function.getKeep(), this);
        this.validateOptionalOrderByElements(function.getOrderByElements());
    }

    @Override
    public void visit(DateValue dateValue) {
    }

    @Override
    public void visit(TimestampValue timestampValue) {
    }

    @Override
    public void visit(TimeValue timeValue) {
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this);
        }
        caseExpression.getWhenClauses().forEach(wc -> wc.accept(this));
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            elseExp.accept(this);
        }
    }

    @Override
    public void visit(WhenClause whenClause) {
        whenClause.getWhenExpression().accept(this);
        whenClause.getThenExpression().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression cast) {
        cast.getLeftExpression().accept(this);
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression aexpr) {
        this.validateOptionalExpression(aexpr.getExpression(), this);
        this.validateOptionalExpression(aexpr.getOffset(), this);
        this.validateOptionalExpression(aexpr.getDefaultValue(), this);
        this.validateOptionalExpression(aexpr.getKeep(), this);
        this.validateOptionalExpressionList(aexpr.getPartitionExpressionList());
        this.validateOptionalOrderByElements(aexpr.getOrderByElements());
        WindowElement windowElement = aexpr.getWindowElement();
        if (windowElement != null) {
            this.validateOptionalWindowOffset(windowElement.getOffset());
            WindowRange range = windowElement.getRange();
            if (range != null) {
                this.validateOptionalWindowOffset(range.getStart());
                this.validateOptionalWindowOffset(range.getEnd());
            }
        }
        this.validateOptionalExpression(aexpr.getFilterExpression());
    }

    private void validateOptionalWindowOffset(WindowOffset offset) {
        if (offset != null) {
            this.validateOptionalExpression(offset.getExpression());
        }
    }

    @Override
    public void visit(ExtractExpression eexpr) {
        eexpr.getExpression().accept(this);
    }

    @Override
    public void visit(IntervalExpression iexpr) {
        this.validateOptionalExpression(iexpr.getExpression());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.validateFeature(Feature.jdbcNamedParameter);
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        this.validateFeature(Feature.oracleHierarchicalExpression);
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.validateOptionalExpression(jsonExpr.getExpression());
    }

    @Override
    public void visit(JsonOperator jsonExpr) {
        this.visitBinaryExpression(jsonExpr, " " + jsonExpr.getStringExpression() + " ");
    }

    @Override
    public void visit(UserVariable var) {
    }

    @Override
    public void visit(NumericBind bind) {
    }

    @Override
    public void visit(KeepExpression aexpr) {
        this.validateOptionalOrderByElements(aexpr.getOrderByElements());
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        this.validateOptionalExpressionList(groupConcat.getExpressionList());
        this.validateOptionalOrderByElements(groupConcat.getOrderByElements());
    }

    private void validateOptionalExpressionList(ExpressionList<?> expressionList) {
        if (expressionList != null) {
            for (Expression expression : expressionList) {
                expression.accept(this);
            }
        }
    }

    @Override
    public void visit(ExpressionList<?> expressionList) {
        this.validateOptionalExpressionList(expressionList);
    }

    public void visit(RowConstructor rowConstructor) {
        this.validateOptionalExpressionList(rowConstructor);
    }

    @Override
    public void visit(RowGetExpression rowGetExpression) {
        rowGetExpression.getExpression().accept(this);
    }

    @Override
    public void visit(OracleHint hint) {
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
    }

    @Override
    public void visit(DateTimeLiteralExpression literal) {
    }

    @Override
    public void visit(NextValExpression nextVal) {
        this.validateName(NamedObject.sequence, nextVal.getName());
    }

    @Override
    public void visit(CollateExpression col) {
        this.validateOptionalExpression(col.getLeftExpression());
    }

    @Override
    public void visit(SimilarToExpression expr) {
        this.validateFeature(Feature.exprSimilarTo);
        this.visitBinaryExpression(expr, (expr.isNot() ? " NOT" : "") + " SIMILAR TO ");
    }

    @Override
    public void visit(ArrayExpression array) {
        array.getObjExpression().accept(this);
        if (array.getIndexExpression() != null) {
            array.getIndexExpression().accept(this);
        }
        if (array.getStartIndexExpression() != null) {
            array.getStartIndexExpression().accept(this);
        }
        if (array.getStopIndexExpression() != null) {
            array.getStopIndexExpression().accept(this);
        }
    }

    @Override
    public void visit(ArrayConstructor aThis) {
        for (Expression expression : aThis.getExpressions()) {
            expression.accept(this);
        }
    }

    @Override
    public void validate(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visit(VariableAssignment a) {
        this.validateOptionalExpression(a.getExpression());
        if (a.getVariable() != null) {
            a.getVariable().accept(this);
        }
    }

    @Override
    public void visit(TimezoneExpression a) {
        this.validateOptionalExpression(a.getLeftExpression());
    }

    @Override
    public void visit(XMLSerializeExpr xml) {
    }

    @Override
    public void visit(JsonAggregateFunction expression) {
    }

    @Override
    public void visit(JsonFunction expression) {
    }

    @Override
    public void visit(ConnectByRootOperator connectByRootOperator) {
        connectByRootOperator.getColumn().accept(this);
    }

    @Override
    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        oracleNamedFunctionParameter.getExpression().accept(this);
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(AllValue allValue) {
    }

    @Override
    public void visit(IsDistinctExpression isDistinctExpression) {
        isDistinctExpression.getLeftExpression().accept(this);
        isDistinctExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(GeometryDistance geometryDistance) {
        this.visitOldOracleJoinBinaryExpression(geometryDistance, " <-> ");
    }

    @Override
    public void visit(Select selectBody) {
    }

    @Override
    public void visit(TranscodingFunction transcodingFunction) {
        transcodingFunction.getExpression().accept(this);
    }

    @Override
    public void visit(TrimFunction trimFunction) {
        if (trimFunction.getExpression() != null) {
            trimFunction.getExpression().accept(this);
        }
        if (trimFunction.getFromExpression() != null) {
            trimFunction.getFromExpression().accept(this);
        }
    }

    @Override
    public void visit(RangeExpression rangeExpression) {
        rangeExpression.getStartExpression().accept(this);
        rangeExpression.getEndExpression().accept(this);
    }
}

