/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.Constraint;
import com.datical.liquibase.ext.checks.config.ConstraintOperatorEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import com.datical.liquibase.ext.checks.config.cli.BooleanGetter;
import com.datical.liquibase.ext.checks.config.cli.DirectoryGetter;
import com.datical.liquibase.ext.checks.config.cli.EnumGetter;
import com.datical.liquibase.ext.checks.config.cli.FilenameGetter;
import com.datical.liquibase.ext.checks.config.cli.PositiveNonZeroIntGetter;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.cli.StringGetter;
import com.datical.liquibase.ext.checks.config.cli.StringListGetter;
import com.datical.liquibase.ext.checks.dynamic.ObjectTypesEnum;
import com.datical.liquibase.ext.checks.dynamic.WarnOnSpecificChangeTypes;
import com.datical.liquibase.ext.command.init.InitProjectCommandStep;
import java.util.Arrays;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;

public enum DynamicRuleParameterEnum {
    MAX_COLUMNS("The maximum number of allowed columns.", (Object)50, "positive numeric value", new PositiveNonZeroIntGetter()),
    SEARCH_STRING("The substring or regular expression to match.", null, "a string, or a valid regular expression", new RegexGetter()),
    PRIVILEGE_LIST("The list of specific privileges that should not be allowed to occur", "Set 'PRIVILEGE_LIST' of users and roles, separated by commas", null, "comma-separated list of valid database privileges", new StringGetter(false)),
    MESSAGE("The message the user wishes to print when the check detects a pattern match.", (Object)("A match for regular expression <" + (Object)((Object)SEARCH_STRING) + "> was detected in Changeset <CHANGESET>."), "", new StringGetter(false)),
    OPERATOR("The location to look for the provided SEARCH_STRING value", (Object)((Object)OperatorEnum.STARTS_WITH), OperatorEnum.values(), new EnumGetter<OperatorEnum>(OperatorEnum.class, true)),
    CONSTRAINT_OPERATOR("The location to look for the provided SEARCH_STRING value", (Object)((Object)ConstraintOperatorEnum.STARTS_WITH), ConstraintOperatorEnum.values(), new EnumGetter<ConstraintOperatorEnum>(ConstraintOperatorEnum.class, true)),
    OBJECT_TYPES("The object(s) to check, such as tables, columns, triggers, etc", "Set 'OBJECT_TYPES' to check, separated by commas", null, ObjectTypesEnum.values(), new StringEnumListGetter<ObjectTypesEnum>(ObjectTypesEnum.class, true)),
    CASE_SENSITIVE("Set how the SearchString is processed.", (Object)true, "true, false", new BooleanGetter()),
    PROJECT_DIR(null, "Enter a relative path to desired project directory", (Object)"./", (String)null, new DirectoryGetter()),
    DEFAULTS_FILENAME(null, "Enter name for defaults file to be created or (s)kip", LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDefaultValue(), (String)null, new FilenameGetter()),
    JDBC_URL(null, "Enter the JDBC url without username or password to be used (What is a JDBC url? <url>)", (Object)"jdbc:h2:tcp://localhost:9090/mem:dev", (String)null, new StringGetter(false)),
    USERNAME(null, "Enter username to connect to JDBC url", (Object)"dbuser", (String)null, new StringGetter(false)),
    PASSWORD(null, "Enter password to connect to JDBC url", (Object)"letmein", (String)null, new StringGetter(false)),
    FILETYPE(null, "Enter your preferred changelog format", (Object)((Object)InitProjectCommandStep.FileTypeEnum.sql), InitProjectCommandStep.FileTypeEnum.values(), new EnumGetter<InitProjectCommandStep.FileTypeEnum>(InitProjectCommandStep.FileTypeEnum.class, true)),
    SAMPLE_CHANGELOG_NAME(null, "Enter name for sample changelog file to be created or (s)kip", (Object)"example-changelog", (String)null, new FilenameGetter()),
    STRIP_COMMENTS("Strip comments from SQL prior to searching for string.", (Object)true, "true, false", new BooleanGetter()),
    EXCEPTIONS_LIST("List of table names which will not trigger this check.", "Set 'EXCEPTIONS_LIST' as a comma-separated list of table names which will not trigger this check", (Object)"", (String)null, new StringListGetter()),
    ALLOWED_LIST("A comma-separated list of keywords which will not trigger this check", null, (String)null, new StringListGetter()),
    TABLE_NAME("The table name string or regex to match.", "Enter the table name string or regex to match (Note: Leave blank to check all tables for column name.)", null, (String)null, new StringGetter(true)),
    COLUMN_NAME("The column name string or regex to match.", "Enter the column name string or regex to match", null, (String)null, new StringGetter(false)),
    CONSTRAINT("", "Enter the required constraint(s), separated by commas", (Object)((Object)Constraint.PRIMARYKEY), Constraint.values(), new StringEnumListGetter<Constraint>(Constraint.class, true)),
    CHANGE_TYPE_LIST("List of Liquibase ChangeTypes to Warn About", "Specify one or more ChangeTypes separated by commas (options: dropTable, dropColumn)", (Object)"dropTable,dropColumn", (String)null, new StringListGetter(WarnOnSpecificChangeTypes.REGISTERED_CHANGE_NAMES));

    public final String description;
    public final String uiMessage;
    public final Object defaultValue;
    public final AbstractCommandLineValueGetter<?> interactiveCommandLineValueGetter;
    public final String options;

    private DynamicRuleParameterEnum(String description, String uiMessage, Object defaultValue, String options, AbstractCommandLineValueGetter<?> interactiveCommandLineValueGetter) {
        this.description = description;
        this.uiMessage = uiMessage;
        this.defaultValue = defaultValue;
        this.options = options;
        this.interactiveCommandLineValueGetter = interactiveCommandLineValueGetter;
    }

    private DynamicRuleParameterEnum(String description, String uiMessage, Object defaultValue, Enum[] options, AbstractCommandLineValueGetter<?> interactiveCommandLineValueGetter) {
        this(description, uiMessage, defaultValue, DynamicRuleParameterEnum.enumOptionsToString(options), interactiveCommandLineValueGetter);
    }

    private DynamicRuleParameterEnum(String description, Object defaultValue, String options, AbstractCommandLineValueGetter<?> interactiveCommandLineValueGetter) {
        this.description = description;
        this.uiMessage = "Set '" + (Object)((Object)this) + "'";
        this.defaultValue = defaultValue;
        this.options = options;
        this.interactiveCommandLineValueGetter = interactiveCommandLineValueGetter;
    }

    private DynamicRuleParameterEnum(String description, Object defaultValue, Enum[] options, AbstractCommandLineValueGetter<?> interactiveCommandLineValueGetter) {
        this(description, defaultValue, DynamicRuleParameterEnum.enumOptionsToString(options), interactiveCommandLineValueGetter);
    }

    private static String enumOptionsToString(Enum[] options) {
        return Arrays.toString(options).replace("[", "").replace("]", "").trim();
    }
}

