/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.RuleListener;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.RulesEngineListener;
import com.datical.liquibase.ext.rules.api.RulesEngineParameters;
import com.datical.liquibase.ext.rules.core.AbstractRulesEngine;
import com.datical.liquibase.ext.rules.core.DefaultRulesEngine;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.logging.Logger;

public final class InferenceRulesEngine
extends AbstractRulesEngine {
    private final DefaultRulesEngine delegate;

    public InferenceRulesEngine() {
        this(new RulesEngineParameters());
    }

    public InferenceRulesEngine(RulesEngineParameters parameters) {
        super(parameters);
        this.delegate = new DefaultRulesEngine(parameters);
    }

    @Override
    public void fire(Rules rules, Facts facts) throws Exception {
        Set<Rule> selectedRules;
        Logger LOGGER = Scope.getCurrentScope().getLog(this.getClass());
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        do {
            LOGGER.fine("Selecting candidate com.datical.liquibase.ext.rules based on the following facts: " + facts);
            selectedRules = this.selectCandidates(rules, facts);
            if (!selectedRules.isEmpty()) {
                this.delegate.fire(new Rules(selectedRules), facts);
                continue;
            }
            LOGGER.fine("No candidate com.datical.liquibase.ext.rules found for facts: " + facts);
        } while (!selectedRules.isEmpty());
    }

    private Set<Rule> selectCandidates(Rules rules, Facts facts) throws Exception {
        TreeSet<Rule> candidates = new TreeSet<Rule>();
        for (Rule rule : rules) {
            if (!rule.evaluate(facts)) continue;
            candidates.add(rule);
        }
        return candidates;
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) throws Exception {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        return this.delegate.check(rules, facts);
    }

    @Override
    public void registerRuleListener(RuleListener ruleListener) {
        super.registerRuleListener(ruleListener);
        this.delegate.registerRuleListener(ruleListener);
    }

    @Override
    public void registerRuleListeners(List<RuleListener> ruleListeners) {
        super.registerRuleListeners(ruleListeners);
        this.delegate.registerRuleListeners(ruleListeners);
    }

    @Override
    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        super.registerRulesEngineListener(rulesEngineListener);
        this.delegate.registerRulesEngineListener(rulesEngineListener);
    }

    @Override
    public void registerRulesEngineListeners(List<RulesEngineListener> rulesEngineListeners) {
        super.registerRulesEngineListeners(rulesEngineListeners);
        this.delegate.registerRulesEngineListeners(rulesEngineListeners);
    }
}

