/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class ChangeSetIdFilter
implements ChangeSetFilter {
    private final String id;

    public ChangeSetIdFilter(String id) {
        this.id = id;
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String changeSetString = changeSet.toString();
        if (this.id.equalsIgnoreCase(changeSet.getId())) {
            return new ChangeSetFilterResult(true, "Changeset to run is " + changeSetString, this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, String.format("Changeset '%s' will not execute because id '%s' does not match '%s'", changeSetString, changeSet.getId(), this.id), this.getClass(), this.getMdcName(), this.getDisplayName());
    }
}

