/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public abstract class AbstractNotAllowedToContainRule
extends AbstractLiquibaseBasicForecastRule {
    public abstract List<Pattern> getReservedPhrase();

    public abstract String getFailureMessage();

    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return Collections.emptyList();
    }

    private boolean doEvaluate(ChangeSet changeSet, List<Change> changes, boolean isRollback, BasicRule basicRule) {
        for (Change change : changes) {
            if (change instanceof AbstractSQLChange && this.doCheck((AbstractSQLChange)change)) {
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(), basicRule, isRollback);
                return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
            }
            if (this.getOtherCompatibleChangeTypes() == null) continue;
            for (Class<? extends Change> otherCompatibleChangeType : this.getOtherCompatibleChangeTypes()) {
                if (!otherCompatibleChangeType.isAssignableFrom(change.getClass()) || !this.doCheck(change)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(), basicRule, isRollback);
                return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
            }
        }
        return this.returnAtEndOfRule(changeSet, basicRule, isRollback);
    }

    @Override
    public final boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        return this.doEvaluate(changeSet, changeSet.getChanges(), false, basicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, BasicRule basicRule) {
        return this.doEvaluate(changeSet, changes, true, basicRule);
    }

    public boolean doCheck(Change change) {
        return false;
    }

    public boolean doCheck(AbstractSQLChange change) {
        String sql = this.getSql(change);
        if (StringUtil.isNotEmpty((String)sql) && StringUtil.isNotEmpty((String)(sql = StringUtil.stripComments((String)sql, (ChangeSet)change.getChangeSet()).toLowerCase()))) {
            for (Pattern reservedPhrase : this.getReservedPhrase()) {
                char ch = '\u0000';
                Matcher matcher = reservedPhrase.matcher(sql);
                boolean contains = matcher.find();
                if (!contains) continue;
                int reservedPhraseIndex = matcher.start();
                if (reservedPhraseIndex != 0) {
                    ch = sql.charAt(reservedPhraseIndex - 1);
                }
                if (reservedPhraseIndex != 0 && Character.isDefined(ch) && !Character.isWhitespace(ch)) continue;
                return true;
            }
        }
        return false;
    }
}

