/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfigFileInfo;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;

public class DynamicRule
extends AbstractConfigurableRule {
    private UUID parentRuleId;
    private List<DynamicRuleParameter> parameters;

    public DynamicRule(boolean enabled, SeverityEnum severity, UUID id, String shortName, String name, String description, UUID parentRuleId, List<DynamicRuleParameter> parameters, CheckSettingsConfigFileInfo fileInfo) {
        super(enabled, severity, id, shortName, name, description, fileInfo);
        this.parentRuleId = parentRuleId;
        this.parameters = parameters;
    }

    public DynamicRuleParameter getParameter(DynamicRuleParameterEnum parameter) {
        for (DynamicRuleParameter dynamicRuleParameter : this.getParameters()) {
            if (!dynamicRuleParameter.getParameterAsEnum().equals((Object)parameter)) continue;
            return dynamicRuleParameter;
        }
        return null;
    }

    public <E extends Enum> E getEnumParameterValue(DynamicRuleParameterEnum parameter, Class<E> enumClass) {
        DynamicRuleParameter theParameter = this.getParameter(parameter);
        if (theParameter != null) {
            return Enum.valueOf(enumClass, theParameter.getValue().toString());
        }
        return null;
    }

    public <E> E getParameterValue(DynamicRuleParameterEnum parameter) {
        DynamicRuleParameter searchStringParam = this.getParameter(parameter);
        if (searchStringParam != null) {
            return (E)searchStringParam.getValue();
        }
        return null;
    }

    public String prettyPrintParameters() {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            return StringUtil.join((Collection)this.parameters.stream().map(p -> p.getParameterAsEnum().toString() + " = " + p.getValue()).collect(Collectors.toList()), (String)System.lineSeparator());
        }
        return "<None>";
    }

    public boolean isCopy() {
        return this.getParentRuleId() != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicRule that = (DynamicRule)o;
        return Objects.equals(this.parentRuleId, that.parentRuleId) && Objects.equals(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentRuleId, this.parameters);
    }

    public DynamicRule() {
    }

    public UUID getParentRuleId() {
        return this.parentRuleId;
    }

    public List<DynamicRuleParameter> getParameters() {
        return this.parameters;
    }

    public void setParentRuleId(UUID parentRuleId) {
        this.parentRuleId = parentRuleId;
    }

    public void setParameters(List<DynamicRuleParameter> parameters) {
        this.parameters = parameters;
    }
}

