/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.resource.Resource;

public class FlowValidateCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow", "validate"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<String> FLOW_SHELL_INTERPRETER;
    public static final CommandArgumentDefinition<Boolean> FLOW_SHELL_KEEP_TEMP_FILES;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final CommandArgumentDefinition<FlowFile> FLOW_FILE_DTO;
    public static final String VALIDATED_KEY = "validated";
    public static final String FLOW_FILE_KEY = "flowFile";
    public static final String FLOW_FILE_LOAD_KEY = "flowFilePath";
    public static final String END_STAGE = "endStage";
    public static final String FLOW_FILE_INHERITED_VARIABLES = "flowFileInheritedVariables";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateActions(List<Action> actions, Map<String, List<Exception>> stageValidationErrors, String flowFileArg) {
        for (Action action : actions) {
            Logger liquibaseLogger = Logger.getLogger("liquibase");
            Level originalLogLevel = liquibaseLogger.getLevel();
            try {
                action.validate(flowFileArg);
            }
            catch (CommandExecutionException e) {
                List<Object> exceptions;
                if (stageValidationErrors.containsKey(action.toString())) {
                    exceptions = stageValidationErrors.get(action.toString());
                    exceptions.add((Object)e);
                    continue;
                }
                exceptions = new ArrayList<CommandExecutionException>();
                exceptions.add((Object)e);
                stageValidationErrors.put(action.toString(), exceptions);
            }
            finally {
                liquibaseLogger.setLevel(originalLogLevel);
            }
        }
    }

    private void validateStage(Stage stage, String stageName, LinkedHashMap<String, Map<String, List<Exception>>> validationErrors, FlowFileLoad flowFileLoad, String flowFileArg, boolean userDefinedStageName) {
        if (stage == null) {
            return;
        }
        LinkedHashMap<String, List<Exception>> stageValidationErrors = new LinkedHashMap<String, List<Exception>>();
        if (this.isEndStage(stageName, userDefinedStageName)) {
            Scope.getCurrentScope().getUI().sendMessage("WARNING: The stage named '" + stageName + "' will not be guaranteed to execute by Liquibase Flow because it falls under the 'stages:' object in the flow file. To guarantee execution of this stage, it should be not be indented.");
        }
        this.validateActions(stage.getActions(), stageValidationErrors, flowFileArg);
        if (!stageValidationErrors.isEmpty()) {
            validationErrors.put(stageName, stageValidationErrors);
        }
        stage.getActions().forEach(action -> this.addNestedFilesToMap(stageName, flowFileLoad, flowFileArg, (Action)action));
    }

    private void addNestedFilesToMap(String stageName, FlowFileLoad flowFileLoad, String flowFileArg, Action action) {
        if (!this.isFlowCommand(action)) {
            return;
        }
        Map<String, Object> cmdArgs = ((LiquibaseCommandAction)action).getCmdArgs();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, Object> entry : cmdArgs.entrySet()) {
            treeMap.put(entry.getKey().replace("-", ""), entry.getValue());
        }
        String flowFileName = (String)treeMap.get(FLOW_FILE_KEY);
        try {
            Resource resource = FlowFileHelper.determineResource(flowFileName);
            Resource parentResource = FlowFileHelper.determineResource(flowFileArg);
            if (this.isNotParent(resource, parentResource)) {
                if (flowFileLoad.nestedFlowFiles == null) {
                    flowFileLoad.nestedFlowFiles = new LinkedHashMap<String, String>();
                }
                flowFileLoad.nestedFlowFiles.put(flowFileName, stageName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isNotParent(Resource resource, Resource parentResource) {
        return parentResource != null && !parentResource.getUri().toString().equalsIgnoreCase(resource.getUri().toString());
    }

    private boolean isFlowCommand(Action action) {
        String command = action.getCommand();
        return command != null && command.equalsIgnoreCase("flow");
    }

    private boolean isEndStage(String stageName, boolean userDefinedStageName) {
        return userDefinedStageName && stageName.equalsIgnoreCase("endstage");
    }

    private void outputValidationErrors(LinkedHashMap<String, Map<String, List<Exception>>> validationErrors, StringBuilder errorsString) throws CommandValidationException {
        if (!validationErrors.isEmpty()) {
            StringBuilder saveErrorsString = errorsString;
            for (Map.Entry<String, Map<String, List<Exception>>> validationErrorEntry : validationErrors.entrySet()) {
                Map<String, List<Exception>> actionValidationErrors = validationErrorEntry.getValue();
                String stageName = validationErrorEntry.getKey();
                for (Map.Entry<String, List<Exception>> actionValidationError : actionValidationErrors.entrySet()) {
                    for (Exception value : actionValidationError.getValue()) {
                        String key = actionValidationError.getKey();
                        errorsString.append("Invalid command in stage: ");
                        errorsString.append(stageName);
                        errorsString.append(": ");
                        errorsString.append(key);
                        errorsString.append(": ");
                        errorsString.append(value);
                        errorsString.append(System.lineSeparator());
                    }
                }
            }
            errorsString.append(System.lineSeparator());
            errorsString.append("Please review for errors. Learn more at https://docs.liquibase.com/commands/flow/flow.html");
            Scope.getCurrentScope().getUI().sendMessage(errorsString.toString());
            saveErrorsString.append("Please review for errors. Learn more at https://docs.liquibase.com/commands/flow/flow.html");
            throw new CommandValidationException(saveErrorsString.toString());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        FlowFileLoad flowFileLoad;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        ConfiguredValue flowFileConfig = commandScope.getConfiguredValue(FLOW_FILE);
        ConfiguredValue passedInFlowFileObject = commandScope.getConfiguredValue(FLOW_FILE_DTO);
        if (passedInFlowFileObject.getValue() != null && flowFileConfig.getValue() != null && !flowFileConfig.wasDefaultValueUsed()) {
            throw new IllegalArgumentException("You can only pass in 1 of 'flowFile' and 'flowFileDTO'");
        }
        String flowFileArg = null;
        AtomicReference<Object> flowFileArgRef = new AtomicReference<Object>(flowFileConfig.getValue());
        try {
            FlowFile flowFile;
            if (passedInFlowFileObject.getValue() != null) {
                flowFile = (FlowFile)passedInFlowFileObject.getValue();
                flowFileLoad = new FlowFileLoad();
                flowFileLoad.flowFile = flowFile;
            } else {
                flowFileArg = (String)flowFileArgRef.get();
                AtomicReference flowFileLoadRef = new AtomicReference();
                AtomicReference flowFileRef = new AtomicReference();
                HashMap<String, Object> scopedValues = new HashMap<String, Object>();
                scopedValues.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
                scopedValues.put(FLOW_SHELL_KEEP_TEMP_FILES.getName(), commandScope.getArgumentValue(FLOW_SHELL_KEEP_TEMP_FILES));
                Scope.child(scopedValues, () -> {
                    Map inheritedVariables = (Map)Scope.getCurrentScope().get(FLOW_FILE_INHERITED_VARIABLES, Map.class);
                    flowFileLoadRef.set(this.loadFlowFileContents((String)flowFileArgRef.get(), flowFileConfig.wasDefaultValueUsed(), (Boolean)commandScope.getArgumentValue(FLOW_FILE_STRICT_PARSING) == false, inheritedVariables));
                    flowFileRef.set(flowFileLoadRef.get() != null ? ((FlowFileLoad)flowFileLoadRef.get()).flowFile : null);
                });
                flowFile = (FlowFile)flowFileRef.get();
                flowFileLoad = (FlowFileLoad)flowFileLoadRef.get();
            }
            if (flowFile == null) {
                resultsBuilder.addResult(VALIDATED_KEY, (Object)Boolean.FALSE);
                return;
            }
            LinkedHashMap<String, Map<String, List<Exception>>> validationErrors = new LinkedHashMap<String, Map<String, List<Exception>>>();
            HashMap<String, Object> scopedValues = new HashMap<String, Object>();
            scopedValues.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
            scopedValues.put(FLOW_SHELL_KEEP_TEMP_FILES.getName(), commandScope.getArgumentValue(FLOW_SHELL_KEEP_TEMP_FILES));
            Scope.child(scopedValues, () -> {
                LinkedHashMap<String, Stage> stages = flowFile.getStages();
                for (Map.Entry<String, Stage> stageEntry : stages.entrySet()) {
                    Stage stage = stageEntry.getValue();
                    String stageName = stageEntry.getKey();
                    this.validateStage(stage, stageName, validationErrors, flowFileLoad, (String)flowFileArgRef.get(), true);
                }
                this.validateStage(flowFile.getEndStage(), END_STAGE, validationErrors, flowFileLoad, (String)flowFileArgRef.get(), false);
            });
            StringBuilder errorsString = passedInFlowFileObject.getValue() == null ? new StringBuilder(String.format("ERROR: Flow file failed validation checks.%n", new Object[0])) : new StringBuilder(String.format("ERROR: Flow file object failed validation checks.%n", new Object[0]));
            this.outputValidationErrors(validationErrors, errorsString);
        }
        catch (IOException e) {
            throw new CommandValidationException(String.format("Error opening file '%s': %s", flowFileArg, e.getMessage()), (Throwable)e);
        }
        if (flowFileArg != null) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("Flow file %s is valid.", flowFileArg));
        } else {
            Scope.getCurrentScope().getUI().sendMessage("Flow file object is valid.");
        }
        Scope.getCurrentScope().getUI().sendMessage("Flow file " + flowFileArg + " is valid.");
        resultsBuilder.addResult(VALIDATED_KEY, (Object)Boolean.TRUE);
        resultsBuilder.addResult(FLOW_FILE_LOAD_KEY, (Object)flowFileLoad);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Validate a series of commands contained in one or more stages, as configured in a liquibase flow-file."));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument(FLOW_FILE_KEY, String.class).defaultValue((Object)"liquibase.flowfile.yaml").description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)true).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
        FLOW_SHELL_INTERPRETER = commandBuilder.argument("flowShellInterpreter", String.class).description("The default interpreter used to execute shell commands.").build();
        FLOW_SHELL_KEEP_TEMP_FILES = commandBuilder.argument("flowShellKeepTempFiles", Boolean.class).defaultValue((Object)false).description("Do not delete temporary files created by the shell command execution").build();
        FLOW_FILE_DTO = commandBuilder.argument("flowFileDTO", FlowFile.class).description("An already loaded FlowFile object").hidden().build();
    }
}

