/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandOverride;
import liquibase.command.CommandScope;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.SnapshotCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtil;

@CommandOverride(override=SnapshotCommandStep.class)
public class ProSnapshotCommandStep
extends SnapshotCommandStep {
    public static final CommandArgumentDefinition<String> SNAPSHOT_FILTERS_ARG;

    protected SnapshotControl createSnapshotControl(CommandScope commandScope, Database database) {
        String typesString = (String)commandScope.getArgumentValue(SNAPSHOT_FILTERS_ARG);
        if (commandScope.getArgumentValue(SNAPSHOT_CONTROL_ARG) != null || typesString == null) {
            return super.createSnapshotControl(commandScope, database);
        }
        Class[] types = ProSnapshotCommandStep.determineTypesToSnapshot(typesString);
        List finalList = Arrays.stream(types).map(Class::getSimpleName).collect(Collectors.toList());
        Scope.getCurrentScope().getLog(ProSnapshotCommandStep.class).info(String.format("Running snapshot with filters: %s", StringUtil.join(finalList, (String)",")));
        return new SnapshotControl(database, types);
    }

    private static Class<? extends DatabaseObject>[] determineTypesToSnapshot(String typesString) {
        Class[] newTypes;
        if (typesString == null) {
            return null;
        }
        Class[] types = DiffCommandStep.parseSnapshotTypes((String[])new String[]{typesString});
        boolean foundOthers = false;
        boolean foundIndexClass = false;
        boolean foundColumnClass = false;
        for (Class type : types) {
            if (type.isAssignableFrom(PrimaryKey.class) || type.isAssignableFrom(ForeignKey.class) || type.isAssignableFrom(UniqueConstraint.class)) {
                foundOthers = true;
            }
            if (type.isAssignableFrom(Index.class)) {
                foundIndexClass = true;
            }
            if (!type.isAssignableFrom(Column.class)) continue;
            foundColumnClass = true;
        }
        if (foundOthers) {
            newTypes = new Class[types.length + 1];
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(types));
            if (!foundIndexClass) {
                list.add(Index.class);
                Scope.getCurrentScope().getLog(ProSnapshotCommandStep.class).fine("Added Index to the types list");
            }
            if (!foundColumnClass) {
                list.add(Column.class);
                Scope.getCurrentScope().getLog(ProSnapshotCommandStep.class).fine("Added Column to the types list");
            }
            if (list.size() > types.length) {
                types = list.toArray(newTypes);
            }
        } else if (foundIndexClass && !foundColumnClass) {
            newTypes = new Class[types.length + 1];
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(types));
            list.add(Column.class);
            Scope.getCurrentScope().getLog(ProSnapshotCommandStep.class).fine("Added Column to the types list");
            types = list.toArray(newTypes);
        }
        return types;
    }

    private static String getAvailableTypes() {
        return "Catalog, CheckConstraint, Column, DatabasePackage, DatabasePackageBody, ForeignKey, Function, Index, PrimaryKey, Schema, Sequence, StoredProcedure, Synonym, Table, Trigger, UniqueConstraint, View";
    }

    private static String getStandardTypes() {
        Set standardTypes = DatabaseObjectFactory.getInstance().getStandardTypes();
        ArrayList typesList = new ArrayList();
        standardTypes.forEach(type -> {
            String[] parts = type.getName().split("\\.");
            String name = parts[parts.length - 1];
            typesList.add(name);
        });
        StringBuilder builder = new StringBuilder();
        Collections.sort(typesList);
        typesList.forEach(name -> {
            if (builder.length() == 0) {
                builder.append((String)name);
            } else {
                builder.append(", ");
                builder.append((String)name);
            }
        });
        return builder.toString();
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        SNAPSHOT_FILTERS_ARG = builder.argument("snapshotFilters", String.class).description(ProStringUtil.markWithPro("Types of objects to snapshot: " + ProSnapshotCommandStep.getAvailableTypes())).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            try {
                LicenseServiceUtils.checkProLicenseAndThrowException((String[])new String[]{"Snapshot with filters"});
            }
            catch (CommandExecutionException cve) {
                throw new IllegalArgumentException(cve.getMessage());
            }
            String typesString = (String)input;
            try {
                DiffCommandStep.parseSnapshotTypes((String[])new String[]{typesString});
            }
            catch (UnexpectedLiquibaseException ule) {
                String message = ule.getMessage();
                if (message != null) {
                    message = message.replace("Unknown snapshot type(s) ", "Unknown snapshot filter(s) '");
                }
                String messageString = String.format("%nWARNING: %s'. %nValid snapshot filter types are %s", message, ProSnapshotCommandStep.getStandardTypes());
                throw new IllegalArgumentException(messageString);
            }
            return typesString;
        }).build();
    }
}

