/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractRollbackOnErrorCommand;
import com.datical.liquibase.ext.command.InternalRollbackOnErrorCommandStep;
import com.datical.liquibase.ext.command.UpdateReportGenerator;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import com.datical.liquibase.ext.command.helpers.VisibleReportCommandArguments;
import com.datical.liquibase.ext.reports.ReportArguments;
import java.util.ArrayList;
import java.util.List;
import liquibase.Scope;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.UpdateCommandStep;
import liquibase.database.Database;
import liquibase.report.UpdateReportParameters;

@CommandOverride(override=UpdateCommandStep.class)
public class ProUpdateCommandStep
extends UpdateCommandStep {
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        ArrayList deps = new ArrayList(super.requiredDependencies());
        deps.add(RollbackOnErrorArgument.class);
        deps.add(VisibleReportCommandArguments.class);
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean rollbackOnError = (Boolean)commandScope.getDependency(RollbackOnErrorArgument.class);
        ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(VisibleReportCommandArguments.class);
        try {
            super.run(resultsBuilder);
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Update command encountered exception", (Throwable)exception);
            InternalRollbackOnErrorCommandStep.executeCommand((Database)commandScope.getDependency(Database.class), (DefaultChangeExecListener)resultsBuilder.getResult("defaultChangeExecListener"), exception, rollbackOnError, (UpdateReportParameters)resultsBuilder.getResult("updateReport"));
        }
        finally {
            UpdateReportParameters updateReportParameters = (UpdateReportParameters)resultsBuilder.getResult("updateReport");
            updateReportParameters.getOperationInfo().setRollbackOnError(rollbackOnError);
            new UpdateReportGenerator().run(resultsBuilder, reportArguments);
        }
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        AbstractRollbackOnErrorCommand.doAdjustCommandDefinition(commandDefinition);
    }
}

