/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommandStep;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.mdc.MdcObject;
import liquibase.resource.Resource;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public class UserMetadataMdcCommandStep
implements CommandStep,
CleanUpCommandStep {
    public static String[] COMMAND_NAME = new String[]{"userMetadataMdc"};
    private Resource customLogDataResource;
    public static final CommandArgumentDefinition<Boolean> RUN_ONCE;
    private static final AtomicInteger EXECUTION_COUNT;
    private static final List<MdcObject> ADDED_MDC_OBJECTS;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public int getOrder(CommandDefinition commandDefinition) {
        return this.shouldRun(null) ? 1 : -1;
    }

    private boolean shouldRun(CommandScope commandScope) {
        boolean runOnce;
        ConfiguredValue currentConfiguredValue = ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue();
        boolean exceededExecutionCountLimit = false;
        if (commandScope != null && (runOnce = ((Boolean)commandScope.getArgumentValue(RUN_ONCE)).booleanValue())) {
            exceededExecutionCountLimit = EXECUTION_COUNT.get() >= 1;
        }
        return !exceededExecutionCountLimit && currentConfiguredValue.found() && LicenseServiceUtils.isProLicenseValid();
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setHidden(true);
    }

    public void validate(CommandScope commandScope) throws CommandValidationException {
        if (this.shouldRun(commandScope)) {
            try {
                this.customLogDataResource = CustomLogDataFile.getResource();
            }
            catch (CommandValidationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CommandValidationException((Throwable)e);
            }
        }
    }

    private boolean commandNameMatches(String commandName, CommandDefinition currentlyExecutingCommand) {
        String executingCommandNameSpace = this.getCommandName(currentlyExecutingCommand, " ");
        String executingCommandNameDash = this.getCommandName(currentlyExecutingCommand, "-");
        String executingCommandName = this.getCommandName(currentlyExecutingCommand, "");
        commandName = commandName.toLowerCase().replace("liquibase.command.", "");
        try {
            commandName = LiquibaseCommandAction.getActualCommandName(commandName)[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return commandName.equalsIgnoreCase(executingCommandNameSpace) || commandName.equalsIgnoreCase(executingCommandNameDash) || commandName.equalsIgnoreCase(executingCommandName);
    }

    private String getCommandName(CommandDefinition commandDefinition, String delimiter) {
        return StringUtil.join((String[])commandDefinition.getName(), (String)delimiter);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        if (this.shouldRun(resultsBuilder.getCommandScope())) {
            EXECUTION_COUNT.getAndIncrement();
            if (!this.customLogDataResource.exists()) {
                return;
            }
            Map<String, Object> customMdcData = CustomLogDataFile.getFileContents();
            if (customMdcData == null) {
                return;
            }
            try {
                this.logMdcData(resultsBuilder, customMdcData);
            }
            catch (Exception e) {
                String message = String.format("ERROR: Invalid or malformed YAML file detected in%n '%s' specified in custom-log-data-file property.%nLearn more about customizing structured logging output at https://docs.liquibase.com/structured-logging", CustomLogDataFile.getResource().getUri().toString().replace("file://", ""));
                Scope.getCurrentScope().getLog(UserMetadataMdcCommandStep.class).severe(message);
                throw new CommandExecutionException(message, (Throwable)e);
            }
        }
    }

    private void logMdcData(CommandResultsBuilder resultsBuilder, Map<String, Object> customMdcData) {
        ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency globalCustomLogDataFrequency = (ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency)((Object)ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FREQUENCY.getCurrentValue());
        Level currentLogLevel = (Level)LiquibaseCommandLineConfiguration.LOG_LEVEL.getCurrentValue();
        HashMap displayOnce = new HashMap();
        HashMap repeated = new HashMap();
        for (Map.Entry<String, Object> stringListEntry : customMdcData.entrySet()) {
            boolean shouldLogMdcData;
            String commandName = stringListEntry.getKey();
            List userMetadata = (List)stringListEntry.getValue();
            boolean bl = shouldLogMdcData = commandName.equalsIgnoreCase("liquibase.usermetadata") || this.commandNameMatches(commandName, resultsBuilder.getCommandScope().getCommand());
            if (!shouldLogMdcData) continue;
            for (LinkedHashMap userMetadatum : userMetadata) {
                String dataKey;
                Object dataObject = userMetadatum.get(dataKey = CollectionUtil.findKeyInMapIgnoreCase((String)"data", (Map)userMetadatum));
                if (dataObject instanceof Map) {
                    if (this.shouldDisplayOnce(userMetadatum, globalCustomLogDataFrequency)) {
                        displayOnce.putAll((Map)dataObject);
                        continue;
                    }
                    repeated.putAll((Map)dataObject);
                    continue;
                }
                Scope.getCurrentScope().getLog(this.getClass()).warning("The supplied 'data' for '" + commandName + "' is not valid.");
            }
        }
        HashMap combined = new HashMap();
        combined.putAll(repeated);
        combined.putAll(displayOnce);
        try (MdcObject userMetadataMdc = Scope.getCurrentScope().addMdcValue("userMetadata", combined);){
            Scope.getCurrentScope().getLog(this.getClass()).log(currentLogLevel, "MDC: " + this.customLogDataResource.getPath(), null);
        }
        if (!repeated.isEmpty()) {
            ADDED_MDC_OBJECTS.add(Scope.getCurrentScope().addMdcValue("userMetadata", repeated, false));
        }
    }

    private boolean shouldDisplayOnce(LinkedHashMap<String, Object> userMetadatum, ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency globalCustomLogDataFrequency) {
        String customLogDataFrequencyKey = CollectionUtil.findKeyInMapIgnoreCase((String)"customLogDataFrequency", userMetadatum);
        if (customLogDataFrequencyKey == null) {
            return globalCustomLogDataFrequency.equals((Object)ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency.ONCE);
        }
        String customLogDataFrequencyValue = String.valueOf(userMetadatum.get(customLogDataFrequencyKey));
        ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency customLogDataFrequency = ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency.valueOf(customLogDataFrequencyValue.toUpperCase());
        return customLogDataFrequency.equals((Object)ExtendedLiquibaseCommandLineConfiguration.CustomLogDataFrequency.ONCE);
    }

    public List<Class<?>> requiredDependencies() {
        return null;
    }

    public List<Class<?>> providedDependencies() {
        return null;
    }

    public void cleanUp(CommandResultsBuilder resultsBuilder) {
        for (MdcObject addedMdcObject : ADDED_MDC_OBJECTS) {
            addedMdcObject.close();
        }
        ADDED_MDC_OBJECTS.clear();
    }

    static {
        EXECUTION_COUNT = new AtomicInteger(0);
        ADDED_MDC_OBJECTS = new ArrayList<MdcObject>();
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        RUN_ONCE = builder.argument("runOnce", Boolean.class).defaultValue((Object)true).hidden().description("If true, the user metadata will only be inserted one time. This is the default behavior. There are some commands, like rollback-one-update which trigger multiple executions of this command step. To output user metadata (potentially) multiple times, set this to false.").build();
    }
}

