/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured;

import com.datical.liquibase.ext.logging.structured.StructuredLogFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Formatter;
import liquibase.Scope;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.LogFormat;
import liquibase.logging.core.JavaLogService;

public class StructuredLogService
extends JavaLogService {
    private static final AtomicBoolean printedNoLicenseMessage = new AtomicBoolean(false);
    private static final Set<LogFormat> VALID_LOG_FORMATS = new HashSet<LogFormat>(Arrays.asList(LogFormat.JSON, LogFormat.JSON_PRETTY));

    public int getPriority() {
        LogFormat logFormat = null;
        try {
            logFormat = (LogFormat)LiquibaseCommandLineConfiguration.LOG_FORMAT.getCurrentValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (VALID_LOG_FORMATS.contains(logFormat)) {
            if (LicenseServiceUtils.isProLicenseValid()) {
                return super.getPriority() + 1;
            }
            boolean registeredValueProviders = (Boolean)Scope.getCurrentScope().get("REGISTERED_VALUE_PROVIDERS", (Object)false);
            if (registeredValueProviders && !printedNoLicenseMessage.getAndSet(true)) {
                Scope.getCurrentScope().getUI().sendMessage("Liquibase structured logging requires a valid Liquibase Pro license. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.");
            }
            return -1;
        }
        return -1;
    }

    public Formatter getCustomFormatter() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return new StructuredLogFormatter();
        }
        return null;
    }
}

