/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.checks;

import com.datical.liquibase.ext.reports.checks.TriggeredCheck;
import com.datical.liquibase.ext.reports.checks.TriggeredCheckCount;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.changelog.ChangeSet;

public class ChangelogChecksRunInfo {
    private int checksTriggered;
    private Integer sqlParserFailSeverity;
    private List<TriggeredCheck> triggeredChecks = new ArrayList<TriggeredCheck>();
    private List<String> checksRun = new ArrayList<String>();
    private List<String> checksSkippedUnsupportedType = new ArrayList<String>();
    private List<String> checksSkippedSqlParse = new ArrayList<String>();
    private Set<ChangeSetCheckResults> changeSetCheckResults = new LinkedHashSet<ChangeSetCheckResults>();
    private TriggeredCheckCount triggeredCheckCount = new TriggeredCheckCount();

    public boolean getShowChecksRun() {
        return !this.checksRun.isEmpty();
    }

    public boolean getShowChecksSkippedUnsupportedType() {
        return !this.checksSkippedUnsupportedType.isEmpty();
    }

    public boolean getShowChecksSkippedSqlParse() {
        return !this.checksSkippedSqlParse.isEmpty();
    }

    public void addChangeSetResults(LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> changeSetResults, String checkSettingsFile) {
        ArrayList checkResultsList = new ArrayList();
        changeSetResults.forEach((changeSet, liquibaseQualityCheckResult) -> {
            List<Rule> executedRules = liquibaseQualityCheckResult.getExecutedRules(checkSettingsFile).stream().map(RuleCombination::getRule).collect(Collectors.toList());
            ChangeSetCheckResults checkResults = new ChangeSetCheckResults();
            checkResults.setChangeSetId(changeSet.getId());
            checkResults.setChangeSetAuthor(changeSet.getAuthor());
            checkResults.setChangeSetFilePath(changeSet.getFilePath());
            checkResults.getTriggeredChecks().addAll(TriggeredCheck.buildTriggeredChecks(liquibaseQualityCheckResult.getRuleResults(), executedRules, this.getSqlParserFailSeverity(), checkSettingsFile));
            if (!checkResults.getTriggeredChecks().isEmpty()) {
                checkResults.setTriggeredCheckCount(TriggeredCheckCount.buildTriggeredCheckCount(checkResults.getTriggeredChecks()));
                checkResultsList.add(checkResults);
            }
        });
        checkResultsList.forEach(checkResults -> {
            this.changeSetCheckResults.stream().filter(existingResults -> existingResults.equals(checkResults)).findFirst().ifPresent(existingResult -> {
                if (existingResult.getTriggeredChecks().addAll(checkResults.getTriggeredChecks())) {
                    existingResult.setTriggeredCheckCount(TriggeredCheckCount.buildTriggeredCheckCount(existingResult.getTriggeredChecks()));
                    this.triggeredCheckCount = TriggeredCheckCount.add(this.triggeredCheckCount, TriggeredCheckCount.buildTriggeredCheckCount(checkResults.getTriggeredChecks()));
                }
            });
            if (this.changeSetCheckResults.add((ChangeSetCheckResults)checkResults)) {
                this.triggeredCheckCount = TriggeredCheckCount.add(this.triggeredCheckCount, TriggeredCheckCount.buildTriggeredCheckCount(checkResults.getTriggeredChecks()));
            }
        });
    }

    public int getChecksTriggered() {
        return this.checksTriggered;
    }

    public Integer getSqlParserFailSeverity() {
        return this.sqlParserFailSeverity;
    }

    public List<TriggeredCheck> getTriggeredChecks() {
        return this.triggeredChecks;
    }

    public List<String> getChecksRun() {
        return this.checksRun;
    }

    public List<String> getChecksSkippedUnsupportedType() {
        return this.checksSkippedUnsupportedType;
    }

    public List<String> getChecksSkippedSqlParse() {
        return this.checksSkippedSqlParse;
    }

    public Set<ChangeSetCheckResults> getChangeSetCheckResults() {
        return this.changeSetCheckResults;
    }

    public TriggeredCheckCount getTriggeredCheckCount() {
        return this.triggeredCheckCount;
    }

    public void setChecksTriggered(int checksTriggered) {
        this.checksTriggered = checksTriggered;
    }

    public void setSqlParserFailSeverity(Integer sqlParserFailSeverity) {
        this.sqlParserFailSeverity = sqlParserFailSeverity;
    }

    public void setTriggeredChecks(List<TriggeredCheck> triggeredChecks) {
        this.triggeredChecks = triggeredChecks;
    }

    public void setChecksRun(List<String> checksRun) {
        this.checksRun = checksRun;
    }

    public void setChecksSkippedUnsupportedType(List<String> checksSkippedUnsupportedType) {
        this.checksSkippedUnsupportedType = checksSkippedUnsupportedType;
    }

    public void setChecksSkippedSqlParse(List<String> checksSkippedSqlParse) {
        this.checksSkippedSqlParse = checksSkippedSqlParse;
    }

    public void setChangeSetCheckResults(Set<ChangeSetCheckResults> changeSetCheckResults) {
        this.changeSetCheckResults = changeSetCheckResults;
    }

    public void setTriggeredCheckCount(TriggeredCheckCount triggeredCheckCount) {
        this.triggeredCheckCount = triggeredCheckCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangelogChecksRunInfo)) {
            return false;
        }
        ChangelogChecksRunInfo other = (ChangelogChecksRunInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChecksTriggered() != other.getChecksTriggered()) {
            return false;
        }
        Integer this$sqlParserFailSeverity = this.getSqlParserFailSeverity();
        Integer other$sqlParserFailSeverity = other.getSqlParserFailSeverity();
        if (this$sqlParserFailSeverity == null ? other$sqlParserFailSeverity != null : !((Object)this$sqlParserFailSeverity).equals(other$sqlParserFailSeverity)) {
            return false;
        }
        List<TriggeredCheck> this$triggeredChecks = this.getTriggeredChecks();
        List<TriggeredCheck> other$triggeredChecks = other.getTriggeredChecks();
        if (this$triggeredChecks == null ? other$triggeredChecks != null : !((Object)this$triggeredChecks).equals(other$triggeredChecks)) {
            return false;
        }
        List<String> this$checksRun = this.getChecksRun();
        List<String> other$checksRun = other.getChecksRun();
        if (this$checksRun == null ? other$checksRun != null : !((Object)this$checksRun).equals(other$checksRun)) {
            return false;
        }
        List<String> this$checksSkippedUnsupportedType = this.getChecksSkippedUnsupportedType();
        List<String> other$checksSkippedUnsupportedType = other.getChecksSkippedUnsupportedType();
        if (this$checksSkippedUnsupportedType == null ? other$checksSkippedUnsupportedType != null : !((Object)this$checksSkippedUnsupportedType).equals(other$checksSkippedUnsupportedType)) {
            return false;
        }
        List<String> this$checksSkippedSqlParse = this.getChecksSkippedSqlParse();
        List<String> other$checksSkippedSqlParse = other.getChecksSkippedSqlParse();
        if (this$checksSkippedSqlParse == null ? other$checksSkippedSqlParse != null : !((Object)this$checksSkippedSqlParse).equals(other$checksSkippedSqlParse)) {
            return false;
        }
        Set<ChangeSetCheckResults> this$changeSetCheckResults = this.getChangeSetCheckResults();
        Set<ChangeSetCheckResults> other$changeSetCheckResults = other.getChangeSetCheckResults();
        if (this$changeSetCheckResults == null ? other$changeSetCheckResults != null : !((Object)this$changeSetCheckResults).equals(other$changeSetCheckResults)) {
            return false;
        }
        TriggeredCheckCount this$triggeredCheckCount = this.getTriggeredCheckCount();
        TriggeredCheckCount other$triggeredCheckCount = other.getTriggeredCheckCount();
        return !(this$triggeredCheckCount == null ? other$triggeredCheckCount != null : !((Object)this$triggeredCheckCount).equals(other$triggeredCheckCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangelogChecksRunInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChecksTriggered();
        Integer $sqlParserFailSeverity = this.getSqlParserFailSeverity();
        result = result * 59 + ($sqlParserFailSeverity == null ? 43 : ((Object)$sqlParserFailSeverity).hashCode());
        List<TriggeredCheck> $triggeredChecks = this.getTriggeredChecks();
        result = result * 59 + ($triggeredChecks == null ? 43 : ((Object)$triggeredChecks).hashCode());
        List<String> $checksRun = this.getChecksRun();
        result = result * 59 + ($checksRun == null ? 43 : ((Object)$checksRun).hashCode());
        List<String> $checksSkippedUnsupportedType = this.getChecksSkippedUnsupportedType();
        result = result * 59 + ($checksSkippedUnsupportedType == null ? 43 : ((Object)$checksSkippedUnsupportedType).hashCode());
        List<String> $checksSkippedSqlParse = this.getChecksSkippedSqlParse();
        result = result * 59 + ($checksSkippedSqlParse == null ? 43 : ((Object)$checksSkippedSqlParse).hashCode());
        Set<ChangeSetCheckResults> $changeSetCheckResults = this.getChangeSetCheckResults();
        result = result * 59 + ($changeSetCheckResults == null ? 43 : ((Object)$changeSetCheckResults).hashCode());
        TriggeredCheckCount $triggeredCheckCount = this.getTriggeredCheckCount();
        result = result * 59 + ($triggeredCheckCount == null ? 43 : ((Object)$triggeredCheckCount).hashCode());
        return result;
    }

    public String toString() {
        return "ChangelogChecksRunInfo(checksTriggered=" + this.getChecksTriggered() + ", sqlParserFailSeverity=" + this.getSqlParserFailSeverity() + ", triggeredChecks=" + this.getTriggeredChecks() + ", checksRun=" + this.getChecksRun() + ", checksSkippedUnsupportedType=" + this.getChecksSkippedUnsupportedType() + ", checksSkippedSqlParse=" + this.getChecksSkippedSqlParse() + ", changeSetCheckResults=" + this.getChangeSetCheckResults() + ", triggeredCheckCount=" + this.getTriggeredCheckCount() + ")";
    }

    public static class ChangeSetCheckResults {
        private String changeSetId;
        private String changeSetAuthor;
        private String changeSetFilePath;
        private TriggeredCheckCount triggeredCheckCount = new TriggeredCheckCount();
        private Set<TriggeredCheck> triggeredChecks = new HashSet<TriggeredCheck>();

        public String getChangeSetId() {
            return this.changeSetId;
        }

        public String getChangeSetAuthor() {
            return this.changeSetAuthor;
        }

        public String getChangeSetFilePath() {
            return this.changeSetFilePath;
        }

        public TriggeredCheckCount getTriggeredCheckCount() {
            return this.triggeredCheckCount;
        }

        public Set<TriggeredCheck> getTriggeredChecks() {
            return this.triggeredChecks;
        }

        public void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public void setChangeSetAuthor(String changeSetAuthor) {
            this.changeSetAuthor = changeSetAuthor;
        }

        public void setChangeSetFilePath(String changeSetFilePath) {
            this.changeSetFilePath = changeSetFilePath;
        }

        public void setTriggeredCheckCount(TriggeredCheckCount triggeredCheckCount) {
            this.triggeredCheckCount = triggeredCheckCount;
        }

        public void setTriggeredChecks(Set<TriggeredCheck> triggeredChecks) {
            this.triggeredChecks = triggeredChecks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeSetCheckResults)) {
                return false;
            }
            ChangeSetCheckResults other = (ChangeSetCheckResults)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$changeSetId = this.getChangeSetId();
            String other$changeSetId = other.getChangeSetId();
            if (this$changeSetId == null ? other$changeSetId != null : !this$changeSetId.equals(other$changeSetId)) {
                return false;
            }
            String this$changeSetAuthor = this.getChangeSetAuthor();
            String other$changeSetAuthor = other.getChangeSetAuthor();
            if (this$changeSetAuthor == null ? other$changeSetAuthor != null : !this$changeSetAuthor.equals(other$changeSetAuthor)) {
                return false;
            }
            String this$changeSetFilePath = this.getChangeSetFilePath();
            String other$changeSetFilePath = other.getChangeSetFilePath();
            return !(this$changeSetFilePath == null ? other$changeSetFilePath != null : !this$changeSetFilePath.equals(other$changeSetFilePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChangeSetCheckResults;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $changeSetId = this.getChangeSetId();
            result = result * 59 + ($changeSetId == null ? 43 : $changeSetId.hashCode());
            String $changeSetAuthor = this.getChangeSetAuthor();
            result = result * 59 + ($changeSetAuthor == null ? 43 : $changeSetAuthor.hashCode());
            String $changeSetFilePath = this.getChangeSetFilePath();
            result = result * 59 + ($changeSetFilePath == null ? 43 : $changeSetFilePath.hashCode());
            return result;
        }

        public String toString() {
            return "ChangelogChecksRunInfo.ChangeSetCheckResults(changeSetId=" + this.getChangeSetId() + ", changeSetAuthor=" + this.getChangeSetAuthor() + ", changeSetFilePath=" + this.getChangeSetFilePath() + ", triggeredCheckCount=" + this.getTriggeredCheckCount() + ", triggeredChecks=" + this.getTriggeredChecks() + ")";
        }
    }
}

