/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageBodyStatement;
import liquibase.ChecksumVersion;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createPackageBody", description="Creates a stored package body", priority=101, appliesTo={"packageBody"})
public class CreatePackageBodyChange
extends CreateProcedureChange {
    private String packageBodyName;
    private String packageBodyText;

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getPackageBodyName();
    }

    public void setProcedureName(String procedureName) {
        this.setPackageBodyName(procedureName);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getPackageBodyText();
    }

    public void setProcedureText(String procedureText) {
        this.setPackageBodyText(procedureText);
    }

    @DatabaseChangeProperty(mustEqualExisting="packageBody", description="Name of the package body to create")
    public String getPackageBodyName() {
        return this.packageBodyName;
    }

    public void setPackageBodyName(String packageBodyName) {
        this.packageBodyName = packageBodyName;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE, description="The SQL creating the package body. You need to define either this attribute or 'path'. packageBodyText is not supported in the XML format; however, you can specify the package body SQL inline within the createPackageBody definition.")
    public String getPackageBodyText() {
        return this.packageBodyText;
    }

    public void setPackageBodyText(String packageBodyText) {
        this.packageBodyText = packageBodyText;
    }

    public String getConfirmationMessage() {
        return "Package body " + this.getPackageBodyName() + " created";
    }

    protected SqlStatement[] generateStatements(String logicText, String endDelimiter, Database database) {
        return new SqlStatement[]{new CreatePackageBodyStatement(this.getCatalogName(), this.getSchemaName(), this.getPackageBodyName(), logicText, endDelimiter)};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public CheckSum generateCheckSum() {
        if (Scope.getCurrentScope().getChecksumVersion().lowerOrEqualThan(ChecksumVersion.V8)) {
            return super.generateCheckSum();
        }
        return super.generateCheckSumLatest(this.packageBodyText);
    }
}

