/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageStatement;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class DropPackageGenerator
extends AbstractSqlGenerator<DropPackageStatement> {
    public boolean supports(DropPackageStatement dropPackageStatement, Database database) {
        return database instanceof DB2Database || database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase;
    }

    public ValidationErrors validate(DropPackageStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("packageName", (Object)statement.getPackageName());
        return validationErrors;
    }

    public Sql[] generateSql(DropPackageStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Sql[]{new UnparsedSql("DROP PACKAGE " + database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getPackageName(), DatabasePackage.class), new DatabaseObject[]{((DatabasePackage)new DatabasePackage().setName(statement.getPackageName())).setSchema(new Schema(statement.getCatalogName(), statement.getSchemaName()))})};
    }
}

