/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.MissingFunctionChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingFunctionExternalFileChangeGenerator
extends MissingFunctionChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && Function.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixMissing(databaseObject, diffOutputControl, database, database2, changeGeneratorChain);
        CreateFunctionChange change = MissingFunctionExternalFileChangeGenerator.findChange(CreateFunctionChange.class, changes);
        change.setRelativeToChangelogFile(true);
        change.setPath(ObjectSqlFileUtil.writeObjectSql((Function)databaseObject));
        change.setFunctionBody(null);
        return changes;
    }
}

