/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.ChecksumVersion;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createTrigger", description="Creates a database trigger", priority=101, appliesTo={"trigger"})
public class CreateTriggerChange
extends CreateProcedureChange {
    private String triggerName;
    private String triggerBody;
    private Boolean disabled;
    private String tableName;
    private String scope;

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = new ValidationErrors();
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
            if (errors.hasErrors()) {
                return errors;
            }
        } else {
            return RefactoringUtils.createValidationErrors(database, (Change)this);
        }
        errors = super.validate(database);
        if (database instanceof MSSQLDatabase && this.getDisabled() != null && this.getDisabled().booleanValue() && this.getScope() == null && this.getTableName() == null) {
            errors.addError("tableName or scope is required when creating a disabled trigger");
        }
        return errors;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getTriggerName();
    }

    public void setProcedureName(String procedureName) {
        this.setTriggerName(procedureName);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getTriggerBody();
    }

    public void setProcedureText(String procedureText) {
        this.setTriggerBody(procedureText);
    }

    @DatabaseChangeProperty(mustEqualExisting="trigger", description="Name of the trigger to create")
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String trigger) {
        this.triggerName = trigger;
    }

    @DatabaseChangeProperty(description="Name of the table the trigger is set on")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="Name of the module for the trigger")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @DatabaseChangeProperty(description="Specifies whether the trigger is disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE, description="The SQL creating the trigger. You need to define either this attribute or 'path'. triggerBody is not supported in the XML format; however, you can specify the trigger SQL inline within the createTrigger definition.")
    public String getTriggerBody() {
        return this.triggerBody;
    }

    public void setTriggerBody(String triggerBody) {
        this.triggerBody = triggerBody;
    }

    public String getConfirmationMessage() {
        return "Trigger " + this.getTriggerName() + " created";
    }

    protected SqlStatement[] generateStatements(String logicText, String endDelimiter, Database database) {
        boolean disabled = false;
        if (this.getDisabled() != null) {
            disabled = this.getDisabled();
        }
        CreateTriggerStatement statement = new CreateTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getTriggerName(), logicText, endDelimiter);
        statement.setDisabled(disabled);
        statement.setScope(this.getScope());
        statement.setTableName(this.getTableName());
        statement.setReplaceIfExists(this.getReplaceIfExists());
        return new SqlStatement[]{statement};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public CheckSum generateCheckSum() {
        if (Scope.getCurrentScope().getChecksumVersion().lowerOrEqualThan(ChecksumVersion.V8)) {
            return super.generateCheckSum();
        }
        return super.generateCheckSumLatest(this.triggerBody);
    }
}

